/*
 * Decompiled with CFR 0.152.
 */
package org.mule.examples.loanbroker.tests;

import junit.framework.Assert;
import org.apache.commons.lang.time.StopWatch;
import org.mule.examples.loanbroker.messages.Customer;
import org.mule.examples.loanbroker.messages.CustomerQuoteRequest;
import org.mule.examples.loanbroker.messages.LoanQuote;
import org.mule.examples.loanbroker.tests.AbstractLoanBrokerTestCase;
import org.mule.extras.client.MuleClient;
import org.mule.providers.NullPayload;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.util.concurrent.Latch;

public abstract class AbstractAsynchronousLoanBrokerTestCase
extends AbstractLoanBrokerTestCase {
    protected int getNumberOfRequests() {
        return 100;
    }

    protected int getDelay() {
        return 30000;
    }

    protected int getWarmUpMessages() {
        return 20;
    }

    public void testSingleLoanRequest() throws Exception {
        MuleClient client = new MuleClient();
        Customer c = new Customer("Ross Mason", 1234);
        CustomerQuoteRequest request = new CustomerQuoteRequest(c, 100000.0, 48);
        client.dispatch("CustomerRequests", (Object)request, null);
        UMOMessage result = client.receive("CustomerResponses", (long)this.getDelay());
        AbstractAsynchronousLoanBrokerTestCase.assertNotNull((String)"Result is null", (Object)result);
        AbstractAsynchronousLoanBrokerTestCase.assertFalse((String)"Result is null", (boolean)(result.getPayload() instanceof NullPayload));
        AbstractAsynchronousLoanBrokerTestCase.assertTrue((String)("Result should be LoanQuote but is " + result.getPayload().getClass().getName()), (boolean)(result.getPayload() instanceof LoanQuote));
        LoanQuote quote = (LoanQuote)result.getPayload();
        AbstractAsynchronousLoanBrokerTestCase.assertTrue((quote.getInterestRate() > 0.0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLotsOfLoanRequests() throws Exception {
        final MuleClient client = new MuleClient();
        Customer c = new Customer("Ross Mason", 1234);
        CustomerQuoteRequest[] requests = new CustomerQuoteRequest[]{new CustomerQuoteRequest(c, 100000.0, 48), new CustomerQuoteRequest(c, 1000.0, 12), new CustomerQuoteRequest(c, 10.0, 24)};
        StopWatch stopWatch = new StopWatch();
        int i = 0;
        final int numRequests = this.getNumberOfRequests() + this.getWarmUpMessages();
        final Latch latch = new Latch();
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    UMOMessage result = null;
                    for (int i = 0; i < numRequests; ++i) {
                        try {
                            result = client.receive("CustomerResponses", (long)AbstractAsynchronousLoanBrokerTestCase.this.getDelay());
                        }
                        catch (UMOException e) {
                            Assert.fail((String)e.getMessage());
                        }
                        Assert.assertNotNull((String)"Result is null", result);
                        Assert.assertFalse((String)"Result is null", (boolean)(result.getPayload() instanceof NullPayload));
                        Assert.assertTrue((String)("Result should be LoanQuote but is " + result.getPayload().getClass().getName()), (boolean)(result.getPayload() instanceof LoanQuote));
                        LoanQuote quote = (LoanQuote)result.getPayload();
                        Assert.assertTrue((quote.getInterestRate() > 0.0 ? 1 : 0) != 0);
                    }
                }
                finally {
                    latch.countDown();
                }
            }
        });
        thread.start();
        try {
            for (i = 0; i < numRequests; ++i) {
                if (i == this.getWarmUpMessages()) {
                    stopWatch.start();
                }
                client.dispatch("CustomerRequests", (Object)requests[i % 3], null);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            latch.await();
            stopWatch.stop();
            System.out.println("Total running time was: " + stopWatch.getTime() + "ms");
            System.out.println("Requests processed was: " + i);
            int mps = (int)((double)numRequests / ((double)stopWatch.getTime() / 1000.0));
            System.out.println("Msg/sec: " + mps + " (warm up msgs= " + this.getWarmUpMessages() + ")");
            throw throwable;
        }
        latch.await();
        stopWatch.stop();
        System.out.println("Total running time was: " + stopWatch.getTime() + "ms");
        System.out.println("Requests processed was: " + i);
        int mps = (int)((double)numRequests / ((double)stopWatch.getTime() / 1000.0));
        System.out.println("Msg/sec: " + mps + " (warm up msgs= " + this.getWarmUpMessages() + ")");
    }
}

