/*
 * Decompiled with CFR 0.152.
 */
package org.mule.samples.errorhandler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.samples.errorhandler.ErrorMessage;
import org.mule.samples.errorhandler.ExceptionHandler;
import org.mule.samples.errorhandler.HandlerException;
import org.mule.samples.errorhandler.LocaleMessage;
import org.mule.samples.errorhandler.handlers.DefaultHandler;
import org.mule.samples.errorhandler.handlers.FatalHandler;
import org.mule.umo.UMOException;

public class ErrorManager {
    private static final Log logger = LogFactory.getLog((Class)ErrorManager.class);
    private Map handlers = new HashMap();
    private ExceptionHandler defaultHandler = new DefaultHandler();

    public void setHandlers(ExceptionHandler[] eh) {
        for (int i = 0; i < eh.length; ++i) {
            this.addHandler(eh[i]);
        }
    }

    public void addHandler(ExceptionHandler eh) {
        Iterator i = eh.getRegisteredClasses();
        while (i.hasNext()) {
            this.handlers.put(i.next(), eh);
        }
    }

    public ExceptionHandler getHandler(Class exceptionClass) {
        Object obj = this.handlers.get(exceptionClass);
        if (obj == null) {
            obj = this.handlers.get(Throwable.class);
        }
        return (ExceptionHandler)obj;
    }

    public void onException(ErrorMessage msg) throws UMOException {
        Class<?> eClass = null;
        ExceptionHandler eh = null;
        try {
            eClass = msg.getException().toException().getClass();
            eh = this.getHandler(eClass);
            eh.onException(msg);
        }
        catch (Exception e) {
            logger.error((Object)LocaleMessage.handlerFailure(eh));
            if (eh instanceof DefaultHandler) {
                logger.error((Object)LocaleMessage.defaultFatalHandling(FatalHandler.class));
                this.handleFatal(e);
            }
            if (eh instanceof FatalHandler) {
                logger.fatal((Object)LocaleMessage.fatalHandling(e));
                ((MuleManager)MuleManager.getInstance()).dispose();
            }
            logger.error((Object)LocaleMessage.defaultHandling(DefaultHandler.class, eh, e));
            this.handleDefault(msg, e);
        }
    }

    private void handleDefault(ErrorMessage msg, Throwable t) {
        ErrorMessage nestedMsg = null;
        try {
            nestedMsg = new ErrorMessage(t);
        }
        catch (Exception e) {
            logger.fatal((Object)LocaleMessage.defaultException(e), (Throwable)e);
            this.handleFatal(e);
        }
        try {
            this.defaultHandler.onException(nestedMsg);
        }
        catch (HandlerException e) {
            logger.fatal((Object)LocaleMessage.defaultHandlerException(e), (Throwable)((Object)e));
            this.handleFatal((Throwable)((Object)e));
        }
    }

    private void handleFatal(Throwable t) {
        logger.fatal((Object)LocaleMessage.fatalException(t), t);
        ((MuleManager)MuleManager.getInstance()).dispose();
    }
}

