/*
 * Decompiled with CFR 0.152.
 */
package com.lehman.knit;

import com.lehman.knit.AnnotationRow;
import com.lehman.knit.AnnotationTable;
import com.lehman.knit.DataWeaveArgument;
import com.lehman.knit.DataWeaveCommentAnnotation;
import com.lehman.knit.DataWeaveDocWriter;
import com.lehman.knit.DataWeaveFile;
import com.lehman.knit.DataWeaveFunction;
import com.lehman.knit.DataWeaveTable;
import com.lehman.knit.DataWeaveVariable;
import com.lehman.knit.Utility;
import java.util.ArrayList;
import java.util.List;

public class MarkdownDataWeaveDocWriterImpl
implements DataWeaveDocWriter {
    @Override
    public String writeDoc(DataWeaveFile file) {
        String tables;
        String functs;
        String ret = "# " + file.name + System.lineSeparator();
        ret = ret + System.lineSeparator();
        if (!file.getComment().getText().equals("")) {
            ret = ret + file.getComment().getText() + System.lineSeparator();
        }
        if (!file.getFileNameAndPath().equals("")) {
            ret = ret + "> Source: `." + file.getFileNameAndPath() + "`" + System.lineSeparator();
        }
        ret = ret + System.lineSeparator();
        String vars = this.writeVariables(file);
        if (!vars.equals("")) {
            ret = ret + "## Variables" + System.lineSeparator() + System.lineSeparator();
            ret = ret + vars;
        }
        if (!(functs = this.writeFunctions(file)).equals("")) {
            ret = ret + "## Functions" + System.lineSeparator() + System.lineSeparator();
            ret = ret + functs;
        }
        if (!(tables = this.writeTables(file)).equals("")) {
            ret = ret + "## Mapping Tables" + System.lineSeparator() + System.lineSeparator();
            ret = ret + tables + System.lineSeparator();
        }
        ret = ret + "([back to top](#))" + System.lineSeparator() + System.lineSeparator();
        return ret;
    }

    @Override
    public String writeDoc(List<DataWeaveFile> files) {
        return this.writeDoc(files, new ArrayList<String>());
    }

    @Override
    public String writeDoc(List<DataWeaveFile> files, List<String> moduleNameList) {
        String ret = "";
        for (String modName : moduleNameList) {
            DataWeaveFile modFile = this.getFileByModuleName(files, modName);
            if (modFile != null) {
                ret = ret + this.writeDoc(modFile);
                continue;
            }
            System.err.println("Warning: Module name '" + modName + "' was supplied in moduleNameList but was not found parsed file list.");
        }
        if (moduleNameList.size() == 0) {
            for (DataWeaveFile dwf : files) {
                if (moduleNameList.contains(dwf.getName())) continue;
                ret = ret + this.writeDoc(dwf);
            }
        }
        return ret;
    }

    @Override
    public String writeHeaderTable(List<DataWeaveFile> files) {
        return this.writeHeaderTable(files, new ArrayList<String>());
    }

    @Override
    public String writeHeaderTable(List<DataWeaveFile> files, List<String> moduleNameList) {
        String ret = "";
        ret = ret + "| Module | Description |" + System.lineSeparator();
        ret = ret + "| :---- | :---- |" + System.lineSeparator();
        for (String modName : moduleNameList) {
            DataWeaveFile modFile = this.getFileByModuleName(files, modName);
            if (modFile != null) {
                ret = ret + "| [" + modFile.getName() + "](#" + modFile.getName().toLowerCase().replace(' ', '-') + ") | " + Utility.stripNewLines(modFile.getComment().getText().trim()) + " | " + System.lineSeparator();
                continue;
            }
            System.err.println("Warning: Module name '" + modName + "' was supplied in moduleNameList but was not found parsed file list.");
        }
        if (moduleNameList.size() == 0) {
            for (DataWeaveFile dwf : files) {
                if (moduleNameList.contains(dwf.getName())) continue;
                ret = ret + "| [" + dwf.getName() + "](#" + dwf.getName().toLowerCase().replace(' ', '-') + ") | " + Utility.stripNewLines(dwf.getComment().getText().trim()) + " | " + System.lineSeparator();
            }
        }
        ret = ret + System.lineSeparator();
        return ret;
    }

    private DataWeaveFile getFileByModuleName(List<DataWeaveFile> files, String name) {
        DataWeaveFile ret = null;
        for (DataWeaveFile dwf : files) {
            if (!dwf.getName().equals(name)) continue;
            ret = dwf;
            break;
        }
        return ret;
    }

    private String writeVariables(DataWeaveFile file) {
        String ret = "";
        for (DataWeaveVariable var : file.getVariables()) {
            ret = ret + "__var__ `" + var.getName() + "`  " + System.lineSeparator() + System.lineSeparator();
            ret = ret + var.getComment().getText().replaceAll(System.lineSeparator(), "  " + System.lineSeparator()) + System.lineSeparator() + System.lineSeparator();
        }
        return ret;
    }

    private String writeFunctions(DataWeaveFile file) {
        String ret = "";
        for (DataWeaveFunction fun : file.getFunctions()) {
            ret = ret + "__fun__ `" + fun.getName() + " (" + this.writeFunctArgs(fun) + ")`" + System.lineSeparator() + System.lineSeparator();
            ret = ret + Utility.stripNewLines(fun.getComment().getText()) + System.lineSeparator() + System.lineSeparator();
            ret = ret + this.writeFunctAnnotations(fun) + System.lineSeparator();
            if (fun.getTable() == null) continue;
            ret = ret + this.writeAnnotationTable(fun.getTable()) + System.lineSeparator();
        }
        return ret;
    }

    private String writeFunctArgs(DataWeaveFunction fun) {
        String ret = "";
        for (int i = 0; i < fun.getArguments().size(); ++i) {
            DataWeaveArgument arg;
            if (i > 0) {
                ret = ret + ", ";
            }
            if ((arg = fun.getArguments().get(i)).getDatatype().equals("")) {
                if (arg.getName().equals("")) continue;
                ret = ret + arg.getName();
                continue;
            }
            ret = ret + arg.getName() + ": " + arg.getDatatype();
        }
        return ret;
    }

    private String writeFunctAnnotations(DataWeaveFunction fun) {
        String ret = "";
        DataWeaveCommentAnnotation retAnn = null;
        for (DataWeaveCommentAnnotation ann : fun.getComment().getAnnotations()) {
            if (ann.getName().toLowerCase().equals("return")) {
                retAnn = ann;
                continue;
            }
            if (!ann.getName().toLowerCase().equals("param")) continue;
            ret = ret + "> __param__ `" + ann.getKey() + "` " + Utility.stripNewLines(ann.getValue()) + System.lineSeparator();
        }
        if (retAnn != null) {
            ret = ret + "> __return__ " + Utility.stripNewLines(retAnn.getValue()) + System.lineSeparator();
        }
        return ret;
    }

    private String writeTables(DataWeaveFile file) {
        String ret = "";
        for (DataWeaveTable table : file.getTables()) {
            ret = ret + Utility.stripNewLines(table.getComment().getText().trim()) + System.lineSeparator() + System.lineSeparator();
            ret = ret + this.writeAnnotationTable(table.getTable());
        }
        return ret;
    }

    private String writeAnnotationTable(AnnotationTable tbl) {
        String ret = "";
        ret = ret + "| " + Utility.join(" | ", tbl.getColumns()) + " | " + System.lineSeparator();
        ret = ret + "| ";
        for (int i = 0; i < tbl.getColumns().size(); ++i) {
            ret = ret + ":---- | ";
        }
        ret = ret + System.lineSeparator();
        for (AnnotationRow row : tbl.getRows()) {
            ret = ret + "| " + Utility.join(" | ", row.getFields()) + " | " + System.lineSeparator();
        }
        return ret;
    }
}

