/*
 * Decompiled with CFR 0.152.
 */
package com.lehman.knit;

import com.lehman.knit.DataWeaveFile;
import com.lehman.knit.KnitParser;
import com.lehman.knit.MarkdownDataWeaveDocWriterImpl;
import com.lehman.knit.Utility;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="knit", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class Main
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter(property="skip")
    boolean skip = false;
    @Parameter(property="files")
    String[] files;
    @Parameter(property="directories")
    String[] directories = new String[0];
    @Parameter(property="consolidateOutput")
    boolean consolidateOutput = true;
    @Parameter(property="outputFile")
    String outputFile = "target/knit-doc.md";
    @Parameter(property="outputHeaderText")
    String outputHeaderText = "";
    @Parameter(property="outputFooterText")
    String outputFooterText = "";
    @Parameter(property="writeHeaderTable")
    boolean writeHeaderTable = false;
    @Parameter(property="moduleList")
    String[] moduleList = new String[0];
    @Parameter(property="dwlFileExt")
    String dwlFileExt = "dwl";
    @Parameter(property="showAbout")
    boolean showAbout = false;

    public void setDirectories(String[] Directories) {
        this.directories = Directories;
    }

    public void setFiles(String[] Files) {
        this.files = Files;
    }

    public void setModuleList(String[] ModuleList) {
        this.moduleList = ModuleList;
    }

    public void parseDirectory(String dirName, ArrayList<DataWeaveFile> parsedFiles) throws Exception {
        KnitParser parser = new KnitParser();
        File dir = new File(dirName);
        if (dir.exists()) {
            if (dir.isDirectory()) {
                for (String name : dir.list()) {
                    String relName = dirName + "/" + name;
                    File f = new File(relName);
                    if (f.isFile() && relName.endsWith("." + this.dwlFileExt)) {
                        parsedFiles.add(parser.parseFile(this.getWorkingDirectory(), relName, this.dwlFileExt));
                        continue;
                    }
                    if (!f.isDirectory()) continue;
                    this.parseDirectory(relName, parsedFiles);
                }
            } else {
                System.err.println("Provided directory '" + dirName + "' isn't a directory.");
            }
        } else {
            System.err.println("Provided directory '" + dirName + "' doesn't exist.");
        }
    }

    public void execute() {
        if (this.showAbout) {
            this.printAbout();
        }
        System.out.println("Running Knit doc generator ...");
        try {
            if (!this.skip) {
                if (!this.consolidateOutput) {
                    System.err.println("Error: knit-maven-plugin <consolidateOutput> is set to false but only single file is currently implemented.");
                    System.exit(1);
                }
                if (this.files.length == 0 && this.directories.length == 0) {
                    System.out.println("Scanning all files under default directory 'src/main/resources/dwl'");
                    this.directories = new String[]{"src/main/resources/dwl"};
                }
                this.writeDwFile();
            } else {
                System.out.println("Info: knit-maven-plugin skipping doc generation. (skip=true)");
            }
        }
        catch (Exception e) {
            System.err.println("Bad news, the knit plugin ran into trouble. If it continues please report it at https://github.com/rsv-code/knit." + System.lineSeparator());
            e.printStackTrace();
        }
    }

    private void writeDwFile() {
        ArrayList<DataWeaveFile> parsedFiles = new ArrayList<DataWeaveFile>();
        try {
            for (String dir : this.directories) {
                this.parseDirectory(this.getWorkingDirectory() + "/" + dir, parsedFiles);
            }
            KnitParser parser = new KnitParser();
            for (String fname : this.files) {
                parsedFiles.add(parser.parseFile(this.getWorkingDirectory(), fname, this.dwlFileExt));
            }
            Collections.sort(parsedFiles);
            MarkdownDataWeaveDocWriterImpl writer = new MarkdownDataWeaveDocWriterImpl();
            String doc = "";
            if (!"".equals(this.outputHeaderText)) {
                doc = doc + this.outputHeaderText + System.lineSeparator() + System.lineSeparator();
            }
            if (this.writeHeaderTable) {
                doc = doc + writer.writeHeaderTable(parsedFiles, Arrays.asList(this.moduleList));
            }
            doc = doc + writer.writeDoc(parsedFiles, Arrays.asList(this.moduleList));
            if (!"".equals(this.outputFooterText)) {
                doc = doc + this.outputFooterText + System.lineSeparator();
            }
            Utility.write(this.getWorkingDirectory() + "/" + this.outputFile, doc, false);
            System.out.println("Document has been written to '" + this.outputFile + "'.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Error: knit-maven-plugin parse failed.");
        }
    }

    private String getWorkingDirectory() {
        Model model = this.project.getModel();
        Build build = model.getBuild();
        File dir = new File(build.getDirectory());
        String ret = dir.getParent();
        if (SystemUtils.IS_OS_WINDOWS) {
            ret = ret.replace("\\", "/");
        }
        return ret;
    }

    private void printAbout() {
        String out = "";
        out = out + " __  __     __   __     __     ______      _____     ______     ______                            " + System.lineSeparator() + "/\\ \\/ /    /\\ \"-.\\ \\   /\\ \\   /\\__  _\\    /\\  __-.  /\\  __ \\   /\\  ___\\                           " + System.lineSeparator() + "\\ \\  _\"-.  \\ \\ \\-.  \\  \\ \\ \\  \\/_/\\ \\/    \\ \\ \\/\\ \\ \\ \\ \\/\\ \\  \\ \\ \\____                          " + System.lineSeparator() + " \\ \\_\\ \\_\\  \\ \\_\\\\\"\\_\\  \\ \\_\\    \\ \\_\\     \\ \\____-  \\ \\_____\\  \\ \\_____\\                         " + System.lineSeparator() + "  \\/_/\\/_/   \\/_/ \\/_/   \\/_/     \\/_/      \\/____/   \\/_____/   \\/_____/                         " + System.lineSeparator() + "                                                                                                  " + System.lineSeparator() + " ______     ______     __   __     ______     ______     ______     ______   ______     ______    " + System.lineSeparator() + "/\\  ___\\   /\\  ___\\   /\\ \"-.\\ \\   /\\  ___\\   /\\  == \\   /\\  __ \\   /\\__  _\\ /\\  __ \\   /\\  == \\   " + System.lineSeparator() + "\\ \\ \\__ \\  \\ \\  __\\   \\ \\ \\-.  \\  \\ \\  __\\   \\ \\  __<   \\ \\  __ \\  \\/_/\\ \\/ \\ \\ \\/\\ \\  \\ \\  __<   " + System.lineSeparator() + " \\ \\_____\\  \\ \\_____\\  \\ \\_\\\\\"\\_\\  \\ \\_____\\  \\ \\_\\ \\_\\  \\ \\_\\ \\_\\    \\ \\_\\  \\ \\_____\\  \\ \\_\\ \\_\\ " + System.lineSeparator() + "  \\/_____/   \\/_____/   \\/_/ \\/_/   \\/_____/   \\/_/ /_/   \\/_/\\/_/     \\/_/   \\/_____/   \\/_/ /_/ " + System.lineSeparator() + "                                                                                                  " + System.lineSeparator();
        out = out + "Knit 1.0.10 - DataWeave Document Generator" + System.lineSeparator();
        out = out + "Written By Austin Lehman" + System.lineSeparator();
        out = out + "austin@rosevillecode.com" + System.lineSeparator();
        out = out + "Copyright 2020 Roseville Code Inc." + System.lineSeparator();
        System.out.println(out);
    }
}

