/*
 * Decompiled with CFR 0.152.
 */
package com.lehman.knit;

import com.lehman.knit.AnnotationRow;
import com.lehman.knit.AnnotationTable;
import com.lehman.knit.DataWeaveArgument;
import com.lehman.knit.DataWeaveComment;
import com.lehman.knit.DataWeaveCommentAnnotation;
import com.lehman.knit.DataWeaveFile;
import com.lehman.knit.DataWeaveFunction;
import com.lehman.knit.DataWeaveTable;
import com.lehman.knit.DataWeaveVariable;
import com.lehman.knit.Utility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KnitParser {
    public DataWeaveFile parseFile(String rootDirName, String fileName, String dwlFileExt) throws IOException {
        DataWeaveFile ret = new DataWeaveFile(fileName.replaceFirst(rootDirName, ""), dwlFileExt);
        String fileStr = Utility.read(fileName);
        this.parseModuleComment(fileStr, ret);
        ret.setVariables(this.parseVariables(fileStr));
        ret.setFunctions(this.parseFunctions(fileStr));
        ret.setTables(this.parseTables(fileStr));
        return ret;
    }

    private void parseModuleComment(String text, DataWeaveFile ret) {
        String funPatternStr = "(\\/\\*\\*(.+?)\\*\\/\\s*%dw)";
        Pattern r = Pattern.compile(funPatternStr, 40);
        Matcher m = r.matcher(text);
        if (m.find()) {
            String commentStr = m.group(2).toString();
            ret.setCommentString(this.parseCommentString(commentStr).trim());
            ret.setComment(this.parseComment(ret.getCommentString()));
        }
    }

    private ArrayList<DataWeaveFunction> parseFunctions(String text) {
        ArrayList<DataWeaveFunction> ret = new ArrayList<DataWeaveFunction>();
        String funPatternStr = "(\\/\\*\\*[^\\/]+?\\*\\/\\s*fun\\s*\\w*\\s*\\(.*?\\))";
        Pattern r = Pattern.compile(funPatternStr, 40);
        Matcher m = r.matcher(text);
        while (m.find()) {
            for (int i = 0; i < m.groupCount(); ++i) {
                ret.add(this.parseFunctionString(m.group(i).toString()));
            }
        }
        return ret;
    }

    private DataWeaveFunction parseFunctionString(String functionString) {
        DataWeaveFunction funct = new DataWeaveFunction();
        String funPatternStr = "\\/\\*\\*(.+?)\\*\\/\\s*fun\\s*(\\w*)\\s*\\((.*?)\\)";
        Pattern r = Pattern.compile(funPatternStr, 40);
        Matcher m = r.matcher(functionString);
        while (m.find()) {
            funct.setCommentString(this.parseCommentString(m.group(1).toString()).trim());
            funct.setName(m.group(2).toString());
            funct.setComment(this.parseComment(funct.getCommentString()));
            funct.setTable(this.parseAnnotationTable(funct.getComment()));
            funct.setArguments(this.parseArguments(m.group(3).toString()));
        }
        return funct;
    }

    private ArrayList<DataWeaveTable> parseTables(String text) {
        ArrayList<DataWeaveTable> ret = new ArrayList<DataWeaveTable>();
        String strippedText = text.replaceAll("do\\s\\{.*?\\-\\-\\-", "");
        int bodyIdx = strippedText.indexOf("---");
        if (bodyIdx >= 0) {
            String bodyStr = strippedText.substring(bodyIdx + 3);
            String tablePatternStr = "\\/\\*\\*([^\\/]+?)\\*\\/";
            Pattern r = Pattern.compile(tablePatternStr, 40);
            Matcher m = r.matcher(bodyStr);
            while (m.find()) {
                DataWeaveTable tbl = this.parseTableString(m.group(1).toString());
                if (tbl == null || tbl.getTable() == null) continue;
                ret.add(tbl);
            }
        }
        return ret;
    }

    private DataWeaveTable parseTableString(String tableString) {
        DataWeaveTable table = new DataWeaveTable();
        table.setCommentString(this.parseCommentString(tableString).trim());
        table.setComment(this.parseComment(table.getCommentString()));
        table.setTable(this.parseAnnotationTable(table.getComment()));
        return table;
    }

    private String parseCommentString(String str) {
        String ret = "";
        for (String line : str.toString().split(System.lineSeparator())) {
            ret = ret + line.replaceFirst("^\\s*\\*\\s*", "") + System.lineSeparator();
        }
        return ret;
    }

    private DataWeaveComment parseComment(String str) {
        DataWeaveComment comment = new DataWeaveComment();
        String pstr = "(.*?)(^@.*)";
        Pattern r = Pattern.compile(pstr, 40);
        Matcher m = r.matcher(str);
        if (m.find()) {
            comment.setText(m.group(1).toString());
            String annStr = m.group(2).toString();
            comment.setAnnotations(this.parseAnnotations(annStr));
        } else {
            comment.setText(str);
        }
        return comment;
    }

    private ArrayList<DataWeaveCommentAnnotation> parseAnnotations(String str) {
        ArrayList<DataWeaveCommentAnnotation> ret = new ArrayList<DataWeaveCommentAnnotation>();
        String pstr = "^@(\\w+)\\s(.*?(?=@))";
        Pattern r = Pattern.compile(pstr, 40);
        Matcher m = r.matcher(str + System.lineSeparator() + "@");
        while (m.find()) {
            DataWeaveCommentAnnotation ann = new DataWeaveCommentAnnotation();
            ann.setName(m.group(1).toString());
            String kvStr = m.group(2).toString();
            if (ann.getName().equals("param")) {
                this.parseAnnotationValue(kvStr, ann);
            } else {
                ann.setValue(kvStr);
            }
            ret.add(ann);
        }
        return ret;
    }

    private void parseAnnotationValue(String str, DataWeaveCommentAnnotation ann) {
        String pstr = "(\\w+)\\s(.*)";
        Pattern r = Pattern.compile(pstr, 40);
        Matcher m = r.matcher(str);
        if (m.find()) {
            ann.setKey(m.group(1).toString());
            ann.setValue(m.group(2).toString());
        }
    }

    private ArrayList<DataWeaveArgument> parseArguments(String str) {
        String[] parts;
        ArrayList<DataWeaveArgument> args = new ArrayList<DataWeaveArgument>();
        for (String part : parts = str.split(",")) {
            DataWeaveArgument arg = new DataWeaveArgument();
            if (part.contains(":")) {
                String[] argParts = part.split(":");
                arg.setName(argParts[0].trim());
                arg.setDatatype(argParts[1].trim());
            } else {
                arg.setName(part.trim());
            }
            args.add(arg);
        }
        return args;
    }

    private ArrayList<DataWeaveVariable> parseVariables(String text) {
        ArrayList<DataWeaveVariable> variables = new ArrayList<DataWeaveVariable>();
        String funPatternStr = "(\\/\\*\\*[^\\/]+?\\*\\/\\s*var\\s*\\w*)";
        Pattern r = Pattern.compile(funPatternStr, 40);
        Matcher m = r.matcher(text);
        while (m.find()) {
            for (int i = 0; i < m.groupCount(); ++i) {
                variables.add(this.parseVariableString(m.group(i).toString()));
            }
        }
        return variables;
    }

    private DataWeaveVariable parseVariableString(String variableString) {
        DataWeaveVariable var = new DataWeaveVariable();
        String varPatternStr = "\\/\\*\\*(.+?)\\*\\/\\s*var\\s*(\\w*)";
        Pattern r = Pattern.compile(varPatternStr, 40);
        Matcher m = r.matcher(variableString);
        while (m.find()) {
            var.setCommentString(this.parseCommentString(m.group(1).toString()).trim());
            var.setName(m.group(2).toString());
            var.setComment(this.parseComment(var.getCommentString()));
        }
        return var;
    }

    private AnnotationTable parseAnnotationTable(DataWeaveComment comment) {
        AnnotationTable tbl = null;
        for (DataWeaveCommentAnnotation ann : comment.getAnnotations()) {
            if (!ann.getName().toLowerCase().equals("table")) continue;
            tbl = new AnnotationTable();
            ArrayList<String> cols = new ArrayList<String>();
            for (String col : Utility.fromArray(ann.getValue().split("(?<!\\\\\\\\),"))) {
                cols.add(col.replaceAll(System.lineSeparator(), ""));
            }
            tbl.setColumns(cols);
            break;
        }
        if (tbl != null) {
            ArrayList<AnnotationRow> rows = new ArrayList<AnnotationRow>();
            for (DataWeaveCommentAnnotation ann : comment.getAnnotations()) {
                if (!ann.getName().toLowerCase().equals("row")) continue;
                AnnotationRow row = new AnnotationRow();
                ArrayList<String> fields = new ArrayList<String>();
                for (String str : ann.getValue().split("(?<!\\\\\\\\),")) {
                    fields.add(str.replaceAll("\\\\\\\\,", ",").replaceAll(System.lineSeparator(), ""));
                }
                row.setFields(fields);
                rows.add(row);
            }
            tbl.setRows(rows);
        }
        return tbl;
    }
}

