/*
 * Decompiled with CFR 0.152.
 */
package com.lehman.knit;

import com.lehman.knit.DataWeaveComment;
import com.lehman.knit.DataWeaveFunction;
import com.lehman.knit.DataWeaveTable;
import com.lehman.knit.DataWeaveVariable;
import com.lehman.knit.Utility;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Pattern;

public class DataWeaveFile
implements Comparable<DataWeaveFile> {
    public String name = "";
    public String fileName = "";
    public String fileNameAndPath = "";
    public ArrayList<String> modulePath = new ArrayList();
    private String commentString = "";
    private DataWeaveComment comment = new DataWeaveComment();
    public ArrayList<DataWeaveFunction> functions = new ArrayList();
    public ArrayList<DataWeaveVariable> variables = new ArrayList();
    public ArrayList<DataWeaveTable> tables = new ArrayList();

    public DataWeaveFile() {
    }

    public DataWeaveFile(String FileNameAndPath, String dwlFileExt) {
        this.fileNameAndPath = FileNameAndPath;
        this.fileName = new File(FileNameAndPath).getName();
        this.name = this.fileName.substring(0, this.fileName.length() - (dwlFileExt.length() + 1));
        String pathStr = FileNameAndPath.substring(0, FileNameAndPath.length() - (dwlFileExt.length() + 1));
        String sepPattern = Pattern.quote("/");
        this.modulePath = Utility.fromArray(pathStr.split(sepPattern));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileNameAndPath() {
        return this.fileNameAndPath;
    }

    public void setFileNameAndPath(String fileNameAndPath) {
        this.fileNameAndPath = fileNameAndPath;
    }

    public ArrayList<String> getModulePath() {
        return this.modulePath;
    }

    public void setModulePath(ArrayList<String> modulePath) {
        this.modulePath = modulePath;
    }

    public String getCommentString() {
        return this.commentString;
    }

    public void setCommentString(String commentString) {
        this.commentString = commentString;
    }

    public DataWeaveComment getComment() {
        return this.comment;
    }

    public void setComment(DataWeaveComment comment) {
        this.comment = comment;
    }

    public ArrayList<DataWeaveFunction> getFunctions() {
        return this.functions;
    }

    public void setFunctions(ArrayList<DataWeaveFunction> functions) {
        this.functions = functions;
    }

    public ArrayList<DataWeaveVariable> getVariables() {
        return this.variables;
    }

    public void setVariables(ArrayList<DataWeaveVariable> variables) {
        this.variables = variables;
    }

    public ArrayList<DataWeaveTable> getTables() {
        return this.tables;
    }

    public void setTables(ArrayList<DataWeaveTable> tables) {
        this.tables = tables;
    }

    public String toString() {
        String rstr = "";
        rstr = rstr + "fileName: " + this.fileName + System.lineSeparator();
        rstr = rstr + "fileNameAndPath: " + this.fileNameAndPath + System.lineSeparator();
        rstr = rstr + "modulePath: " + Utility.join("::", this.modulePath) + System.lineSeparator();
        return rstr;
    }

    @Override
    public int compareTo(DataWeaveFile o) {
        return this.getName().toLowerCase(Locale.ROOT).compareTo(o.getName().toLowerCase(Locale.ROOT));
    }
}

