/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.lexical.formatstype;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.WriterBase;
import com.mulesoft.lexical.formatstype.FormatError;
import com.mulesoft.lexical.formatstype.TypeBaseFormat;
import com.mulesoft.lexical.formatstype.validation.FormatTypeFunction;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

public class CheckAllowedChars
implements FormatTypeFunction<String, String> {
    @Override
    public String apply(String value, TypeBaseFormat typeFormat, ErrorHandler handler) throws LexicalException {
        HashSet<Character> removed = new HashSet<Character>();
        int substitutionChar = this.getSubstitutionChar(handler);
        boolean[] allowed = typeFormat.getAllowedChars();
        String returnValue = value;
        for (int i = 0; i < value.length(); ++i) {
            boolean notAllowed;
            char chr = value.charAt(i);
            boolean outOfRange = chr >= allowed.length && !typeFormat.getOpenEnded();
            boolean bl = notAllowed = chr < allowed.length && !allowed[chr];
            if (!outOfRange && !notAllowed || removed.contains(Character.valueOf(chr))) continue;
            String removingChr = StringUtils.remove((String)returnValue, (char)chr);
            this.notifyInvalidChars(returnValue.length() - removingChr.length(), chr, typeFormat, handler);
            if (substitutionChar > 0) {
                returnValue = StringUtils.replaceChars((String)returnValue, (char)chr, (char)((char)substitutionChar));
            } else if (substitutionChar == 0) {
                returnValue = removingChr;
            }
            removed.add(Character.valueOf(chr));
        }
        return returnValue;
    }

    private void notifyInvalidChars(int times, char chr, TypeBaseFormat typeFormat, ErrorHandler handler) throws LexicalException {
        for (int j = 0; j < times; ++j) {
            FormatError.invalidCharacter(chr, handler, typeFormat);
        }
    }

    private int getSubstitutionChar(ErrorHandler handler) {
        int substitutionChar = 0;
        if (handler instanceof LexerBase) {
            substitutionChar = ((LexerBase)handler).getSubstitutionChar();
        } else if (handler instanceof WriterBase) {
            substitutionChar = ((WriterBase)handler).getSubstitutionChar();
        }
        return substitutionChar;
    }
}

