/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.control;

import com.mulesoft.flatfile.lexical.LexicalException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public abstract class StructureController {
    protected static final String MIXING_STRUCTURES_ERROR_MESSAGE = "Individual messages and functional groups have been mixed at the same level in the interchange";
    protected String interchangeOpeningIdent;
    protected String groupOpeningIdent;
    protected String messageOpeningIdent;
    protected String messageClosingIdent;
    protected String groupClosingIdent;
    protected String interchangeClosingIdent;
    protected final Stack<String> structureStack;
    protected String atTopEnvelopeIdent;
    protected final Map<String, String> pairsMap = new HashMap<String, String>();
    protected final Map<String, String> hierarchiesMap = new HashMap<String, String>();

    protected StructureController(List<String> envelopeSegmentTags) {
        this.structureStack = new Stack();
        this.initialize(envelopeSegmentTags);
    }

    protected void initialize(List<String> envelopeSegmentTags) {
        envelopeSegmentTags.forEach(this.structureStack::push);
        this.interchangeOpeningIdent = (String)this.structureStack.remove(0);
        this.interchangeClosingIdent = this.structureStack.pop();
    }

    protected void initMaps() {
        this.initPairMap();
        this.initHierarchyMap();
    }

    protected void initPairMap() {
        this.pairsMap.put(this.interchangeClosingIdent, this.interchangeOpeningIdent);
        this.pairsMap.put(this.messageClosingIdent, this.messageOpeningIdent);
    }

    protected abstract void initHierarchyMap();

    public void startControl() {
        this.push(this.interchangeOpeningIdent);
    }

    public boolean isValidEnvelopeSequence(String currentEnvelopeIdent) throws LexicalException {
        return this.isEnvelopeOpeningSegment(currentEnvelopeIdent) ? this.isStackableStructure(currentEnvelopeIdent) : this.isValidPair(currentEnvelopeIdent);
    }

    protected abstract void checkItDoesntHaveMixedStructures(String var1, String var2, String var3) throws LexicalException;

    private boolean isValidPair(String currentEnvelopeIdent) {
        this.atTopEnvelopeIdent = this.pop();
        String envelopeOpenIdent = this.pairsMap.get(currentEnvelopeIdent);
        return this.atTopEnvelopeIdent.equals(envelopeOpenIdent);
    }

    protected boolean isStackableStructure(String currentEnvelopeIdent) throws LexicalException {
        String parentEnvelopeIdent = this.getParentEnvelopeIdent(currentEnvelopeIdent);
        return this.atTopEnvelopeIdent.equals(parentEnvelopeIdent);
    }

    private String getParentEnvelopeIdent(String currentEnvelopeIdent) throws LexicalException {
        String parentEnvelopeIdent = this.hierarchiesMap.get(currentEnvelopeIdent);
        this.atTopEnvelopeIdent = this.peek();
        this.checkItDoesntHaveMixedStructures(this.atTopEnvelopeIdent, parentEnvelopeIdent, currentEnvelopeIdent);
        return parentEnvelopeIdent;
    }

    protected boolean isEnvelopeOpeningSegment(String currentEnvelopeIdent) {
        return currentEnvelopeIdent.equals(this.groupOpeningIdent) || currentEnvelopeIdent.equals(this.messageOpeningIdent);
    }

    public boolean isEnvelopeClosingSegment(String currentEnvelopeIdent) {
        return currentEnvelopeIdent.equals(this.interchangeClosingIdent) || currentEnvelopeIdent.equals(this.messageClosingIdent);
    }

    public String push(String envelopeIdent) {
        return this.structureStack.push(envelopeIdent);
    }

    public String pop() {
        return this.structureStack.pop();
    }

    public String peek() {
        return this.structureStack.peek();
    }

    public int size() {
        return this.structureStack.size();
    }

    public String getAtTopEnvelopeIdent() {
        return this.atTopEnvelopeIdent;
    }
}

