/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.lexical.formatstype;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.lexical.formatstype.ClassPatternMatching;
import com.mulesoft.lexical.formatstype.FormatError;
import com.mulesoft.lexical.formatstype.SingleConverter;
import com.mulesoft.lexical.formatstype.TypeBaseFormat;
import com.mulesoft.lexical.formatstype.TypeFormatFormatter;
import com.mulesoft.lexical.formatstype.validation.TypeFormatValidation;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseFormatter<A>
implements TypeFormatFormatter {
    private List<ClassPatternMatching<A>> patterns = new ArrayList<ClassPatternMatching<A>>();
    private List<SingleConverter> outputConverters = new ArrayList<SingleConverter>();
    private List<TypeFormatValidation<String>> validations = new ArrayList<TypeFormatValidation<String>>();

    public BaseFormatter withPatternMatching(ClassPatternMatching pattern) {
        this.patterns.add(pattern);
        return this;
    }

    public BaseFormatter withOutputConverter(SingleConverter converter) {
        this.outputConverters.add(converter);
        return this;
    }

    public BaseFormatter withValidation(TypeFormatValidation<String> validation) {
        this.validations.add(validation);
        return this;
    }

    @Override
    public String format(Object value, TypeBaseFormat typeFormat, ErrorHandler handler) throws LexicalException {
        A convertedValue = this.getConvertedValue(value, typeFormat, handler);
        if (convertedValue == null) {
            return "";
        }
        String formatted = this.doFormat(convertedValue, typeFormat, handler);
        String toReturn = this.applyConversions(formatted, typeFormat, handler);
        this.applyValidations(toReturn, typeFormat, handler);
        return toReturn;
    }

    private void applyValidations(String value, TypeBaseFormat typeFormat, ErrorHandler handler) throws LexicalException {
        for (TypeFormatValidation<String> v : this.validations) {
            v.validate(value, typeFormat, handler);
        }
    }

    private String applyConversions(String formatted, TypeBaseFormat typeFormat, ErrorHandler handler) throws LexicalException {
        String ret = formatted;
        for (SingleConverter c : this.outputConverters) {
            ret = c.convert(ret, handler, typeFormat);
        }
        return ret;
    }

    private A getConvertedValue(Object value, TypeBaseFormat typeFormat, ErrorHandler handler) throws LexicalException {
        if (value == null) {
            FormatError.wrongType(null, handler, typeFormat);
            return this.valueToUseForNull(typeFormat, handler);
        }
        for (ClassPatternMatching<A> pattern : this.patterns) {
            if (!pattern.match(value)) continue;
            return pattern.convert(value, handler, typeFormat);
        }
        FormatError.wrongType(value, handler, typeFormat);
        return this.valueToUseForWrong(value, typeFormat, handler);
    }

    protected abstract A valueToUseForWrong(Object var1, TypeBaseFormat var2, ErrorHandler var3);

    protected abstract A valueToUseForNull(TypeBaseFormat var1, ErrorHandler var2);

    protected abstract String doFormat(A var1, TypeBaseFormat var2, ErrorHandler var3) throws LexicalException;
}

