/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.formats;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.WriterBase;
import java.io.IOException;

public abstract class TypeFormatBase
implements TypeFormat {
    protected static final char[] SPACES = "                   ".toCharArray();
    protected static final char[] ZEROES = "0000000000000000000".toCharArray();
    protected final String typeCode;
    protected final int minLength;
    protected final int maxLength;

    public TypeFormatBase(String code, int min, int max) {
        if (max < min) {
            throw new IllegalArgumentException("Maximum length cannot be less than minimum length");
        }
        if (min < 0) {
            throw new IllegalArgumentException("Negative length is not allowed");
        }
        this.typeCode = code;
        this.minLength = min;
        this.maxLength = max;
    }

    @Override
    public String typeCode() {
        return this.typeCode;
    }

    @Override
    public int minLength() {
        return this.minLength;
    }

    @Override
    public int maxLength() {
        return this.maxLength;
    }

    protected void wrongType(Object obj, ErrorHandler handler) throws LexicalException {
        if (obj == null) {
            handler.error(this, ErrorHandler.ErrorCondition.WRONG_TYPE, "null value not allowed");
        } else {
            handler.error(this, ErrorHandler.ErrorCondition.WRONG_TYPE, "incompatible type for supplied value object: " + obj.getClass().getName());
        }
    }

    protected void tooShort(int length, ErrorHandler handler) throws LexicalException {
        handler.error(this, ErrorHandler.ErrorCondition.TOO_SHORT, "effective length " + length + " is less than " + this.minLength);
    }

    protected void tooLong(int length, ErrorHandler handler) throws LexicalException {
        handler.error(this, ErrorHandler.ErrorCondition.TOO_LONG, "effective length " + length + " is greater than " + this.maxLength);
    }

    protected void invalidCharacter(char chr, ErrorHandler handler) throws LexicalException {
        handler.error(this, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + chr + "' not allowed");
    }

    protected void noValuePresent(LexerBase lexer) throws LexicalException {
        lexer.error(this, ErrorHandler.ErrorCondition.INVALID_FORMAT, "no value present");
    }

    protected void invalidInput(LexerBase lexer) throws LexicalException {
        lexer.error(this, ErrorHandler.ErrorCondition.INVALID_FORMAT, "input does not match format");
    }

    public void checkInputLength(LexerBase lexer) throws LexicalException {
        StringBuilder builder = lexer.tokenBuilder();
        int length = builder.length();
        if (length < this.minLength) {
            this.tooShort(length, lexer);
        }
        if (length > this.maxLength) {
            this.tooLong(length, lexer);
            builder.setLength(this.maxLength);
        }
    }

    public String checkOutputLength(String token, WriterBase writer) throws LexicalException {
        int length = token.length();
        if (length < this.minLength) {
            this.tooShort(length, writer);
        }
        if (length > this.maxLength) {
            this.tooLong(length, writer);
            return token.substring(0, this.maxLength);
        }
        return token;
    }

    public String checkOutputMaxLength(String token, WriterBase writer) throws LexicalException {
        int length = token.length();
        if (length > this.maxLength) {
            this.tooLong(length, writer);
            return token.substring(0, this.maxLength);
        }
        return token;
    }

    public void verifyDigits(LexerBase lexer) throws LexicalException {
        StringBuilder builder = lexer.tokenBuilder();
        for (int i = 0; i < builder.length(); ++i) {
            char chr = builder.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            this.invalidCharacter(chr, lexer);
            builder.deleteCharAt(i--);
        }
    }

    protected static void stripSpaceLeft(StringBuilder builder) {
        int index;
        for (index = 0; index < builder.length() && builder.charAt(index) == ' '; ++index) {
        }
        if (index > 0) {
            builder.delete(0, index);
        }
    }

    protected static void stripSpaceRight(StringBuilder builder) {
        int index;
        for (index = builder.length() - 1; index >= 0 && builder.charAt(index) == ' '; --index) {
        }
        if (index < builder.length() - 1) {
            builder.delete(index + 1, builder.length());
        }
    }

    protected static void writePadding(int count, char[] padding, WriterBase writer) throws IOException {
        int use;
        for (int remain = count; remain > 0; remain -= use) {
            use = Math.min(remain, padding.length);
            writer.writeUnchecked(padding, 0, use);
        }
    }

    public static void fillPadding(int count, char[] padding, StringBuilder builder) {
        int use;
        for (int remain = count; remain > 0; remain -= use) {
            use = Math.min(remain, padding.length);
            builder.append(padding, 0, use);
        }
    }

    protected static void appendTwoDigit(int num, StringBuilder builder) {
        if (num < 10) {
            builder.append('0');
        }
        builder.append(num);
    }

    protected static void appendFourDigit(int num, StringBuilder builder) {
        if (num < 1000) {
            builder.append('0');
            if (num < 100) {
                builder.append('0');
                if (num < 10) {
                    builder.append('0');
                }
            }
        }
        builder.append(num);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TypeFormatBase) {
            TypeFormatBase format = (TypeFormatBase)obj;
            return this.maxLength == format.maxLength && this.minLength == format.minLength && this.typeCode.equals(format.typeCode);
        }
        return false;
    }
}

