/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical;

import com.mulesoft.flatfile.lexical.EdiConstants;
import com.mulesoft.flatfile.lexical.ErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.logging.log4j.2.12.2.LogManager;
import org.apache.logging.log4j.2.12.2.Logger;

public abstract class LexerBase
implements ErrorHandler {
    protected static final Logger logger = LogManager.getLogger(LexerBase.class);
    protected final InputStream stream;
    protected final int altDecimalMark;
    protected Reader reader;
    protected ErrorHandler errorHandler;
    protected int substitutionChar;
    protected int groupCount;
    protected int segmentNumber;
    protected int elementNumber;
    protected EdiConstants.ItemType currentType;
    protected StringBuilder tokenBuilder;

    public LexerBase(InputStream is, int altmark) {
        this.stream = is;
        this.altDecimalMark = altmark;
        this.tokenBuilder = new StringBuilder();
    }

    public int getAltDecimalMark() {
        return this.altDecimalMark;
    }

    public void setHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public abstract void discardTo(EdiConstants.ItemType var1) throws IOException;

    public void discardSegment() throws IOException {
        this.discardTo(EdiConstants.ItemType.SEGMENT);
    }

    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Throwable throwable) {}
        } else {
            try {
                this.stream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void readArray(byte[] byts, int from) throws IOException {
        int count;
        for (int offset = from; byts.length > offset; offset += count) {
            count = this.stream.read(byts, offset, byts.length - offset);
            if (count > 0) continue;
            throw new IOException("Required data missing from message");
        }
    }

    byte[] readBytes(int num) throws IOException {
        byte[] byts = new byte[num];
        this.readArray(byts, 0);
        return byts;
    }

    public int getSubstitutionChar() {
        return this.substitutionChar;
    }

    public void countGroup() {
        ++this.groupCount;
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public int getElementNumber() {
        return this.elementNumber;
    }

    public EdiConstants.ItemType currentType() {
        return this.currentType;
    }

    public String token() {
        return this.tokenBuilder.toString();
    }

    public StringBuilder tokenBuilder() {
        return this.tokenBuilder;
    }
}

