/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.2.12.2.message;

import org.apache.logging.log4j.2.12.2.message.AbstractMessageFactory;
import org.apache.logging.log4j.2.12.2.message.Message;
import org.apache.logging.log4j.2.12.2.message.ParameterizedMessage;
import org.apache.logging.log4j.2.12.2.message.SimpleMessage;

public final class ParameterizedNoReferenceMessageFactory
extends AbstractMessageFactory {
    private static final long serialVersionUID = 5027639245636870500L;
    public static final ParameterizedNoReferenceMessageFactory INSTANCE = new ParameterizedNoReferenceMessageFactory();

    @Override
    public Message newMessage(String message, Object ... params) {
        if (params == null) {
            return new SimpleMessage(message);
        }
        ParameterizedMessage msg = new ParameterizedMessage(message, params);
        return new StatusMessage(msg.getFormattedMessage(), msg.getThrowable());
    }

    static class StatusMessage
    implements Message {
        private static final long serialVersionUID = 4199272162767841280L;
        private final String formattedMessage;
        private final Throwable throwable;

        public StatusMessage(String formattedMessage, Throwable throwable) {
            this.formattedMessage = formattedMessage;
            this.throwable = throwable;
        }

        @Override
        public String getFormattedMessage() {
            return this.formattedMessage;
        }

        @Override
        public String getFormat() {
            return this.formattedMessage;
        }

        @Override
        public Object[] getParameters() {
            return null;
        }

        @Override
        public Throwable getThrowable() {
            return this.throwable;
        }
    }
}

