/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical;

import com.mulesoft.flatfile.lexical.DelimiterLexer;
import com.mulesoft.flatfile.lexical.EdiConstants;
import com.mulesoft.flatfile.lexical.LexicalException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class TradacomsLexer
extends DelimiterLexer {
    public TradacomsLexer(InputStream is, Charset charset, int subst) {
        super(is, -1);
        this.substitutionChar = subst;
        this.segmentTerminator = (char)39;
        this.dataSeparator = (char)43;
        this.componentSeparator = (char)58;
        this.repetitionSeparator = -1;
        this.releaseIndicator = 63;
        this.subCompSeparator = -1;
        this.tagDelimiter = 61;
        this.reader = new BufferedReader(new InputStreamReader(this.stream, charset));
    }

    public void init() throws LexicalException {
        try {
            char[] chrs = new char[4];
            this.reader.read(chrs);
            String tag = new String(chrs);
            if (!"STX=".equals(tag)) {
                throw new RuntimeException("Message does not start with 'STX='");
            }
            this.segmentTag = "STX";
            this.advance(EdiConstants.ItemType.DATA_ELEMENT);
            this.elementNumber = 1;
        }
        catch (IOException e) {
            throw new LexicalException("Message aborted due to error reading header", e);
        }
    }

    @Override
    protected void handleEscape() throws IOException {
        int value = this.reader.read();
        if (value >= 0) {
            char chr = (char)value;
            this.peekToken.append(chr);
        }
    }
}

