/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical;

import java.nio.charset.Charset;

public final class EdiConstants {
    public static final Charset ASCII_CHARSET = Charset.forName("US-ASCII");
    public static final Charset ISO88591_CHARSET = Charset.forName("ISO-8859-1");
    public static final int maximumYear = 2070;

    private EdiConstants() {
    }

    public static void fillChars(char from, char to, boolean[] flags) {
        for (int i = from; i <= to; ++i) {
            flags[i] = true;
        }
    }

    public static void setChars(char[] chars, boolean[] flags) {
        for (int i = 0; i < chars.length; ++i) {
            flags[chars[i]] = true;
        }
    }

    public static enum ItemType {
        SEGMENT(0),
        END(0),
        REPETITION(-1),
        DATA_ELEMENT(1),
        COMPONENT(2),
        SUB_COMPONENT(3);

        private final int indexNum;

        private ItemType(int index) {
            this.indexNum = index;
        }

        public ItemType nextLevel() {
            if (this.ordinal() < DATA_ELEMENT.ordinal()) {
                throw new IllegalStateException("No granularity defined for item type " + this.toString());
            }
            if (this.ordinal() == ItemType.values().length - 1) {
                return this;
            }
            return ItemType.values()[this.ordinal() + 1];
        }

        public boolean isAbove(ItemType other) {
            return other.indexNum >= 0 && this.indexNum < other.indexNum;
        }

        public static ItemType finest(ItemType a, ItemType b) {
            if (a.indexNum >= b.indexNum) {
                return a;
            }
            return b;
        }
    }
}

