/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexicalDataException;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.WriterBase;
import java.io.BufferedWriter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatFileWriter
extends WriterBase {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final char[] SPACES = "                                                                                               ".toCharArray();
    private final Charset encoding;
    private Boolean supportsRaw;
    private char[] rawTransform;

    public FlatFileWriter(OutputStream os, Charset enc) {
        super(new LineBasedWriter(os, enc), '.');
        this.encoding = enc;
    }

    @Override
    public void init(Map<String, Object> props) {
    }

    @Override
    public void term(Map<String, Object> props) {
    }

    @Override
    public void writeSegmentTag(String tag) throws IOException {
        ((LineBasedWriter)this.writer).segmentStart(tag);
    }

    @Override
    public void writeToken(String text) throws IOException {
        this.writer.write(text);
    }

    @Override
    public void error(TypeFormat typ, ErrorHandler.ErrorCondition err, String text) throws LexicalException {
        boolean abort = false;
        try {
            if (this.errorHandler == null) {
                throw new LexicalDataException(typ, err, text);
            }
            this.errorHandler.error(typ, err, text);
        }
        catch (LexicalException e) {
            abort = true;
            throw e;
        }
        finally {
            if (abort) {
                this.logger.error("Unrecoverable lexer error " + text);
            } else {
                this.logger.info("Recoverable lexer error " + text);
            }
        }
    }

    @Override
    public void startToken() throws IOException {
    }

    @Override
    public void writeUnchecked(char[] chars, int offset, int length) throws IOException {
        this.writer.write(chars, offset, length);
    }

    @Override
    public void writeUnchecked(String text) throws IOException {
        this.writer.write(text);
    }

    @Override
    public void writeEscaped(String text) throws IOException {
        this.writer.write(text);
    }

    public void writeRaw(byte[] bytes) throws IOException {
        char[] chars;
        if (this.supportsRaw == null) {
            ByteBuffer bbuf = ByteBuffer.allocate(256);
            for (int i = 0; i < 256; ++i) {
                bbuf.put((byte)i);
            }
            bbuf.position(0);
            CharBuffer cbuf = this.encoding.decode(bbuf);
            byte[] rbytes = this.encoding.encode(cbuf).array();
            this.supportsRaw = Boolean.FALSE;
            if (rbytes.length == 256) {
                this.supportsRaw = Boolean.TRUE;
                for (int i = 0; i < 256; ++i) {
                    if ((rbytes[i] & 0xFF) == i) continue;
                    this.supportsRaw = Boolean.FALSE;
                    break;
                }
                this.rawTransform = cbuf.array();
            }
        }
        if (this.supportsRaw.booleanValue()) {
            chars = new char[bytes.length];
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = this.rawTransform[bytes[i] & 0xFF];
            }
        } else {
            throw new IllegalStateException("Raw data is not supported for character encoding " + this.encoding.name());
        }
        this.writer.write(chars);
    }

    public void setTagField(int start) {
        ((LineBasedWriter)this.writer).setTagField(start);
    }

    public void writeBlank(int size) throws IOException {
        int rem;
        for (rem = size; rem >= SPACES.length; rem -= SPACES.length) {
            this.writer.write(SPACES);
        }
        if (rem > 0) {
            this.writer.write(SPACES, 0, rem);
        }
    }

    @Override
    public void writeSegmentTerminator() throws IOException {
        ((LineBasedWriter)this.writer).setSegmentEnd();
        ++this.segmentCount;
    }

    private static class LineBasedWriter
    extends FilterWriter {
        private int tagStart = -1;
        private String segmentTag;
        private boolean atEnd;
        private int remainLead;

        protected LineBasedWriter(OutputStream os, Charset encoding) {
            super(new BufferedWriter(new OutputStreamWriter(os, encoding)));
        }

        protected void setSegmentEnd() {
            this.atEnd = true;
        }

        private void checkEnd() throws IOException {
            if (this.atEnd) {
                this.atEnd = false;
                super.write(10);
            }
        }

        protected void setTagField(int start) {
            this.tagStart = start;
        }

        public void segmentStart(String tag) throws IOException {
            if (this.tagStart == 0) {
                this.write(tag);
                this.remainLead = 0;
            } else if (this.tagStart > 0) {
                this.segmentTag = tag;
                this.remainLead = this.tagStart;
            }
        }

        @Override
        public void write(int c) throws IOException {
            this.checkEnd();
            super.write(c);
            if (this.remainLead > 0) {
                --this.remainLead;
                if (this.remainLead == 0) {
                    this.write(this.segmentTag);
                }
            }
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.checkEnd();
            super.write(cbuf, off, len);
            if (this.remainLead > 0) {
                this.remainLead -= len;
                if (this.remainLead == 0) {
                    this.write(this.segmentTag);
                } else if (this.remainLead < 0) {
                    throw new IllegalArgumentException("value spans start tag position");
                }
            }
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            this.checkEnd();
            super.write(str, off, len);
            if (this.remainLead > 0) {
                this.remainLead -= len;
                if (this.remainLead == 0) {
                    this.write(this.segmentTag);
                } else if (this.remainLead < 0) {
                    throw new IllegalArgumentException("value spans start tag position");
                }
            }
        }
    }
}

