/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical;

import com.mulesoft.flatfile.lexical.EdiConstants;
import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalDataException;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormat;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class FlatFileLexer
extends LexerBase {
    private final LineBasedReader typedReader;
    private final Charset encoding;
    private final boolean allowRaw;
    private Boolean supportsRaw;
    private byte[] rawTransform;

    public FlatFileLexer(InputStream is, Charset enc, boolean raw) {
        super(is, -1);
        this.encoding = enc;
        this.allowRaw = raw;
        this.typedReader = new LineBasedReader(this.stream, enc);
        this.reader = this.typedReader;
    }

    @Override
    public void discardTo(EdiConstants.ItemType typ) throws IOException {
        if (typ != EdiConstants.ItemType.SEGMENT) {
            throw new IllegalArgumentException("Flat files do not support " + (Object)((Object)typ) + " data type positioning");
        }
        this.nextLine();
    }

    public boolean nextLine() throws IOException {
        return this.typedReader.nextLine();
    }

    public void setTagField(int start, int length) {
        this.typedReader.setTagField(start, length);
    }

    public void init() throws IOException {
        int chr = this.reader.read();
        if (chr >= 0) {
            ((LineBasedReader)this.reader).loadTag((char)chr);
        } else {
            this.currentType = EdiConstants.ItemType.END;
        }
    }

    public void load(int width) throws IOException {
        this.tokenBuilder.setLength(0);
        this.typedReader.readToken(width);
        this.currentType = EdiConstants.ItemType.DATA_ELEMENT;
    }

    public byte[] rawToken() throws IOException {
        if (!this.allowRaw) {
            throw new IllegalStateException("Lexer is not configured for raw data access");
        }
        if (this.supportsRaw == null) {
            CharBuffer cbuf = CharBuffer.allocate(256);
            for (int i = 0; i < 256; ++i) {
                cbuf.put((char)i);
            }
            cbuf.position(0);
            ByteBuffer bbuf = this.encoding.encode(cbuf);
            char[] rchars = this.encoding.decode(bbuf).array();
            this.supportsRaw = Boolean.FALSE;
            if (rchars.length == 256) {
                this.supportsRaw = Boolean.TRUE;
                for (int i = 0; i < 256; ++i) {
                    if (rchars[i] == i) continue;
                    this.supportsRaw = Boolean.FALSE;
                    break;
                }
                this.rawTransform = bbuf.array();
            }
        }
        if (this.supportsRaw.booleanValue()) {
            String token2 = this.token();
            byte[] bytes = new byte[token2.length()];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = this.rawTransform[token2.charAt(i)];
            }
            return bytes;
        }
        throw new IllegalStateException("Raw data is not supported for character encoding " + this.encoding.name());
    }

    @Override
    public void error(TypeFormat typ, ErrorHandler.ErrorCondition err, String explain) throws LexicalException {
        boolean abort = false;
        String position = "element " + Integer.toString(this.elementNumber + 1);
        String text = err.text() + " for data type " + typ.typeCode() + " at " + position + ": '" + this.tokenBuilder + "'";
        if (explain != null) {
            text = text + " (" + explain + ")";
        }
        try {
            if (this.errorHandler == null) {
                throw new LexicalDataException(typ, err, text);
            }
            this.errorHandler.error(typ, err, explain);
        }
        catch (LexicalException e) {
            abort = true;
            throw e;
        }
        finally {
            if (abort) {
                this.logger.error("Unrecoverable lexer error " + text);
            } else {
                this.logger.info("Recoverable lexer error " + text);
            }
        }
    }

    private class LineBasedReader
    extends FilterReader {
        private int tagStart;
        private int tagLength;
        private int leadOffset;
        private char[] leadBuffer;

        protected LineBasedReader(InputStream in, Charset enc) {
            super(new BufferedReader(new InputStreamReader(FlatFileLexer.this.stream, enc)));
            this.leadBuffer = new char[1];
            this.leadOffset = 1;
            this.tagStart = 1;
        }

        protected void setTagField(int start, int length) {
            this.tagStart = length > 0 ? start : 1;
            this.tagLength = length;
            this.leadBuffer = new char[this.tagStart];
            this.leadOffset = this.tagStart;
        }

        protected void loadTag(char chr) throws IOException {
            if (this.tagLength > 0) {
                FlatFileLexer.this.tokenBuilder.setLength(0);
                if (this.tagStart > 0) {
                    this.leadBuffer[0] = chr;
                    int offset = 1;
                    int actual = 0;
                    for (int remain = this.tagStart - 1; remain > 0 && (actual = this.read(this.leadBuffer, offset, remain)) > 0; remain -= actual) {
                        offset += actual;
                    }
                    if (actual < 0) {
                        throw new EOFException("read only " + offset + " with " + this.tagStart + " expected");
                    }
                    this.leadOffset = 0;
                } else {
                    FlatFileLexer.this.tokenBuilder.append(chr);
                }
                this.readToken(this.tagLength - FlatFileLexer.this.tokenBuilder.length());
                FlatFileLexer.this.segmentTag = FlatFileLexer.this.tokenBuilder.toString();
            } else {
                this.leadBuffer[0] = chr;
                this.leadOffset = 0;
                FlatFileLexer.this.segmentTag = "";
            }
            ++FlatFileLexer.this.segmentNumber;
            FlatFileLexer.this.elementNumber = 0;
            FlatFileLexer.this.currentType = EdiConstants.ItemType.SEGMENT;
        }

        protected boolean nextLine() throws IOException {
            int chr = this.read();
            if (chr == -1) {
                FlatFileLexer.this.currentType = EdiConstants.ItemType.END;
                return false;
            }
            if (chr != 10 && chr != 13) {
                throw new LexicalException("Missing expected line break after line " + FlatFileLexer.this.segmentNumber);
            }
            while ((chr = FlatFileLexer.this.reader.read()) == 10 || chr == 13) {
            }
            if (chr == -1) {
                FlatFileLexer.this.currentType = EdiConstants.ItemType.END;
                return false;
            }
            this.loadTag((char)chr);
            return true;
        }

        protected void readToken(int length) throws IOException {
            for (int i = 0; i < length; ++i) {
                int chr = this.read();
                if (chr == -1) {
                    throw new LexicalException("Unexpected end of file in line " + FlatFileLexer.this.segmentNumber);
                }
                if (!(FlatFileLexer.this.allowRaw || chr != 13 && chr != 10)) {
                    throw new LexicalException("Unexpected end of line (expected " + (length - i) + " more characters) for line " + FlatFileLexer.this.segmentNumber);
                }
                FlatFileLexer.this.tokenBuilder.append((char)chr);
            }
            ++FlatFileLexer.this.elementNumber;
        }

        @Override
        public int read() throws IOException {
            if (this.leadOffset < this.tagStart) {
                return this.leadBuffer[this.leadOffset++];
            }
            return super.read();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int actual = 0;
            int remain = len;
            if (this.leadOffset < this.tagStart) {
                int use = Math.min(len, this.tagStart - this.leadOffset);
                System.arraycopy(this.leadBuffer, this.leadOffset, cbuf, off, use);
                this.leadOffset += use;
                actual = use;
                remain -= use;
            }
            if (remain > 0) {
                return actual + super.read(cbuf, off + actual, remain);
            }
            return actual;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void mark(int readAheadLimit) throws IOException {
            throw new UnsupportedOperationException("mark() is not supported");
        }
    }
}

