/*
 * Decompiled with CFR 0.152.
 */
package com.anypoint.df.edi.lexical;

import com.anypoint.df.edi.lexical.EdiConstants;
import com.anypoint.df.edi.lexical.ErrorHandler;
import com.anypoint.df.edi.lexical.LexerBase;
import com.anypoint.df.edi.lexical.LexicalDataException;
import com.anypoint.df.edi.lexical.LexicalException;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;

public class FlatFileLexer
extends LexerBase {
    public FlatFileLexer(InputStream is) {
        super(is);
        this.reader = new LineBasedReader(this.stream);
    }

    @Override
    public void discardTo(EdiConstants.ItemType typ) throws IOException {
        if (typ != EdiConstants.ItemType.SEGMENT) {
            throw new IllegalArgumentException("Flat files do not support " + (Object)((Object)typ) + " data type positioning");
        }
        this.nextLine();
    }

    public boolean nextLine() throws IOException {
        return ((LineBasedReader)this.reader).nextLine();
    }

    public void setTagField(int start, int length) {
        ((LineBasedReader)this.reader).setTagField(start, length);
    }

    public void init() throws IOException {
        int chr = this.reader.read();
        if (chr >= 0) {
            ((LineBasedReader)this.reader).loadTag(chr);
        } else {
            this.currentType = EdiConstants.ItemType.END;
        }
    }

    public void load(int width) throws IOException {
        this.tokenBuilder.setLength(0);
        ((LineBasedReader)this.reader).readToken(width);
        this.currentType = EdiConstants.ItemType.DATA_ELEMENT;
    }

    @Override
    void handleError(EdiConstants.DataType typ, ErrorHandler.ErrorCondition err, String explain) throws LexicalException {
        boolean abort = false;
        String position = "element " + Integer.toString(this.elementNumber + 1);
        String text = err.text() + " for data type " + typ.code() + " at " + position + ": '" + this.tokenBuilder + "'";
        if (explain != null) {
            text = text + " (" + explain + ")";
        }
        try {
            if (this.errorHandler == null) {
                throw new LexicalDataException(typ, err, text);
            }
            this.errorHandler.error(this, typ, err, explain);
        }
        catch (LexicalException e) {
            abort = true;
            throw e;
        }
        finally {
            if (abort) {
                this.logger.error((Object)("Unrecoverable lexer error " + text));
            } else {
                this.logger.info((Object)("Recoverable lexer error " + text));
            }
        }
    }

    public String parseAlphaNumeric(int minl, int maxl) throws IOException {
        this.load(maxl);
        int lastns = -1;
        for (int i = 0; i < maxl; ++i) {
            if (this.tokenBuilder.charAt(i) == ' ') continue;
            lastns = i;
        }
        this.checkLength(EdiConstants.DataType.ALPHANUMERIC, lastns + 1, minl, maxl);
        return this.tokenBuilder.substring(0, lastns + 1);
    }

    @Override
    public Integer parseInteger(int minl, int maxl) throws IOException {
        this.load(maxl);
        return super.parseInteger(minl, maxl);
    }

    @Override
    public Object parseBigInteger(int minl, int maxl) throws IOException {
        this.load(maxl);
        return super.parseBigInteger(minl, maxl);
    }

    @Override
    public Object parseBigDecimal(int minl, int maxl) throws IOException {
        this.load(maxl);
        return super.parseBigDecimal(minl, maxl);
    }

    @Override
    public Object parseUnscaledNumber(int minl, int maxl) throws IOException {
        this.load(maxl);
        return super.parseUnscaledNumber(minl, maxl);
    }

    @Override
    public Calendar parseDate(int minl, int maxl) throws IOException {
        this.load(maxl);
        return super.parseDate(minl, maxl);
    }

    @Override
    public int parseTime(int minl, int maxl) throws IOException {
        this.load(maxl);
        return super.parseTime(minl, maxl);
    }

    private class LineBasedReader
    extends FilterReader {
        private int tagStart;
        private int tagLength;
        private int leadOffset;
        private char[] leadBuffer;

        protected LineBasedReader(InputStream in) {
            super(new BufferedReader(new InputStreamReader(FlatFileLexer.this.stream, EdiConstants.ASCII_CHARSET)));
        }

        protected void setTagField(int start, int length) {
            this.tagStart = start;
            this.tagLength = length;
            this.leadBuffer = new char[start];
        }

        protected void loadTag(int chr) throws IOException {
            FlatFileLexer.this.tokenBuilder.setLength(0);
            if (this.tagStart > 0) {
                this.leadBuffer[0] = (char)chr;
                int offset = 1;
                int actual = 0;
                for (int remain = this.tagStart - 1; remain > 0 && (actual = this.read(this.leadBuffer, offset, remain)) > 0; remain -= actual) {
                    offset += actual;
                }
                if (actual < 0) {
                    throw new EOFException("read only " + offset + " with " + this.tagStart + " expected");
                }
                this.leadOffset = 0;
            } else {
                FlatFileLexer.this.tokenBuilder.append((char)chr);
            }
            ++FlatFileLexer.this.segmentNumber;
            FlatFileLexer.this.elementNumber = 0;
            this.readToken(this.tagLength - FlatFileLexer.this.tokenBuilder.length());
            FlatFileLexer.this.segmentTag = FlatFileLexer.this.tokenBuilder.toString();
            FlatFileLexer.this.currentType = EdiConstants.ItemType.SEGMENT;
        }

        protected boolean nextLine() throws IOException {
            int chr = this.read();
            if (chr == -1) {
                FlatFileLexer.this.currentType = EdiConstants.ItemType.END;
                return false;
            }
            if (chr != 10 && chr != 13) {
                throw new LexicalException("Missing expected line break after line " + FlatFileLexer.this.segmentNumber);
            }
            while ((chr = FlatFileLexer.this.reader.read()) == 10 || chr == 13) {
            }
            if (chr == -1) {
                FlatFileLexer.this.currentType = EdiConstants.ItemType.END;
                return false;
            }
            this.loadTag(chr);
            return true;
        }

        protected void readToken(int length) throws IOException {
            for (int i = 0; i < length; ++i) {
                int chr = this.read();
                if (chr == -1) {
                    throw new LexicalException("Unexpected end of file in line " + FlatFileLexer.this.segmentNumber);
                }
                if (chr == 13 || chr == 10) {
                    throw new LexicalException("Unexpected end of line (expected " + (length - i) + " more characters) for line " + FlatFileLexer.this.segmentNumber);
                }
                FlatFileLexer.this.tokenBuilder.append((char)chr);
            }
            ++FlatFileLexer.this.elementNumber;
        }

        @Override
        public int read() throws IOException {
            if (this.leadOffset < this.tagStart) {
                return this.leadBuffer[this.leadOffset++];
            }
            return super.read();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int actual = 0;
            int remain = len;
            if (this.leadOffset < this.tagStart) {
                int use = Math.min(len, this.tagStart - this.leadOffset);
                System.arraycopy(this.leadBuffer, this.leadOffset, cbuf, off, use);
                this.leadOffset += use;
                actual = use;
                remain -= use;
            }
            if (remain > 0) {
                return actual + super.read(cbuf, off + actual, remain);
            }
            return actual;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void mark(int readAheadLimit) throws IOException {
            throw new UnsupportedOperationException("mark() is not supported");
        }
    }
}

