/*
 * Decompiled with CFR 0.152.
 */
package com.anypoint.df.edi.lexical;

import com.anypoint.df.edi.lexical.EdiConstants;
import com.anypoint.df.edi.lexical.LexerBase;
import com.anypoint.df.edi.lexical.LexicalException;
import com.anypoint.df.edi.lexical.X12Constants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Map;

public class X12Lexer
extends LexerBase {
    public X12Lexer(InputStream is, Charset charset) {
        super(is);
        this.reader = new BufferedReader(new InputStreamReader(this.stream, charset));
    }

    public void configure(int subst, X12Constants.CharacterRestriction chset) {
        this.substitutionChar = subst;
        this.allowedChars = chset.flags();
    }

    private static InterchangeStartStatus replaceValidStatus(InterchangeStartStatus status, InterchangeStartStatus replace) {
        if (status == InterchangeStartStatus.VALID) {
            return replace;
        }
        return status;
    }

    public InterchangeStartStatus init(Map<String, Object> props) {
        try {
            int value = this.reader.read();
            while (value == 10 || value == 13 || value == 32) {
                value = this.reader.read();
            }
            if (value < 0) {
                return InterchangeStartStatus.NO_DATA;
            }
            char[] chrs = new char[]{(char)value, (char)this.reader.read(), (char)this.reader.read()};
            String tag = new String(chrs);
            if (!"ISA".equals(tag)) {
                throw new IllegalStateException("Message is missing ISA segment (starts with " + tag + ")");
            }
            this.dataSeparator = (char)this.reader.read();
            this.advance(EdiConstants.ItemType.DATA_ELEMENT);
            InterchangeStartStatus result = InterchangeStartStatus.VALID;
            try {
                props.put("ISA01", this.parseId(2, 2));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.AUTHORIZATION_QUALIFIER_ERROR);
                this.advance();
            }
            try {
                props.put("ISA02", this.parseAlphaNumeric(10, 10));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.AUTHORIZATION_INFO_ERROR);
                this.advance();
            }
            try {
                props.put("ISA03", this.parseId(2, 2));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.SECURITY_QUALIFIER_ERROR);
                this.advance();
            }
            try {
                props.put("ISA04", this.parseAlphaNumeric(10, 10));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.SECURITY_INFO_ERROR);
                this.advance();
            }
            try {
                props.put("ISA05", this.parseId(2, 2));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.SENDER_ID_QUALIFIER_ERROR);
                this.advance();
            }
            try {
                props.put("ISA06", this.parseAlphaNumeric(15, 15));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.SENDER_ID_ERROR);
                this.advance();
            }
            try {
                props.put("ISA07", this.parseId(2, 2));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.RECEIVER_ID_QUALIFIER_ERROR);
                this.advance();
            }
            try {
                props.put("ISA08", this.parseAlphaNumeric(15, 15));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.RECEIVER_ID_ERROR);
                this.advance();
            }
            try {
                props.put("ISA09", this.parseDate(6, 6));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.INTERCHANGE_DATE_ERROR);
                this.advance();
            }
            try {
                props.put("ISA10", this.parseTime(4, 4));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.INTERCHANGE_TIME_ERROR);
                this.advance();
            }
            String sep = this.token();
            this.repetitionSeparator = "U".equals(sep) ? -1 : (int)sep.charAt(0);
            this.advance();
            try {
                props.put("ISA12", this.parseId(5, 5));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.VERSION_ID_ERROR);
                this.advance();
            }
            try {
                props.put("ISA13", this.parseInteger(9, 9));
            }
            catch (LexicalException e) {
                throw new LexicalException("Interchange aborted due to Interchange Control Number error", e);
            }
            try {
                props.put("ISA14", this.parseId(1, 1));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.ACK_REQUESTED_ERROR);
                this.advance();
            }
            String indicator = this.token();
            if (indicator.length() != 1 || !"I".equals(indicator) && !"P".equals(indicator) && !"T".equals(indicator)) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.TEST_INDICATOR_ERROR);
            }
            props.put("ISA15", indicator);
            this.componentSeparator = (char)this.reader.read();
            this.segmentTerminator = (char)this.reader.read();
            ++this.segmentNumber;
            this.groupCount = 0;
            this.advance(EdiConstants.ItemType.SEGMENT);
            return result;
        }
        catch (IOException e) {
            throw new IllegalStateException("Interchange aborted due to error reading header", e);
        }
    }

    public InterchangeEndStatus term(Map<String, Object> props) throws IOException {
        if (!"IEA".equals(this.token())) {
            throw new IllegalStateException("not at trailer");
        }
        this.advance();
        int count = this.parseInteger(1, 5);
        if (count != this.groupCount) {
            return InterchangeEndStatus.GROUP_COUNT_ERROR;
        }
        this.checkInteger(9, 9);
        String text = this.token();
        int number = Integer.valueOf(text);
        Object expected = props.get("ISA13");
        if (!(expected instanceof Integer)) {
            throw new IllegalStateException("ISA13 value must be an Integer");
        }
        if ((Integer)expected != number) {
            return InterchangeEndStatus.CONTROL_NUMBER_ERROR;
        }
        return InterchangeEndStatus.VALID;
    }

    public static enum InterchangeEndStatus {
        VALID,
        GROUP_COUNT_ERROR,
        CONTROL_NUMBER_ERROR;

    }

    public static enum InterchangeStartStatus {
        VALID,
        AUTHORIZATION_QUALIFIER_ERROR,
        AUTHORIZATION_INFO_ERROR,
        SECURITY_QUALIFIER_ERROR,
        SECURITY_INFO_ERROR,
        SENDER_ID_QUALIFIER_ERROR,
        SENDER_ID_ERROR,
        RECEIVER_ID_QUALIFIER_ERROR,
        RECEIVER_ID_ERROR,
        INTERCHANGE_DATE_ERROR,
        INTERCHANGE_TIME_ERROR,
        VERSION_ID_ERROR,
        INTER_CONTROL_ERROR,
        ACK_REQUESTED_ERROR,
        TEST_INDICATOR_ERROR,
        NO_DATA;

    }
}

