/*
 * Decompiled with CFR 0.152.
 */
package com.anypoint.df.edi.lexical;

import com.anypoint.df.edi.lexical.DelimiterLexer;
import com.anypoint.df.edi.lexical.EdiConstants;
import com.anypoint.df.edi.lexical.ErrorHandler;
import com.anypoint.df.edi.lexical.LexicalException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class HL7Lexer
extends DelimiterLexer {
    private final DatatypeFactory typeFactory;

    public HL7Lexer(InputStream is, int subst) {
        super(is);
        this.substitutionChar = subst;
        this.segmentTerminator = (char)13;
        try {
            this.typeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    void handleEscape() throws IOException {
        block12: {
            int code;
            block11: {
                int value;
                code = this.reader.read();
                if (code < 0) {
                    throw new LexicalException("end of input in escape sequence");
                }
                StringBuilder builder = new StringBuilder();
                while ((value = this.reader.read()) >= 0 && value != this.releaseIndicator) {
                    builder.append((char)value);
                }
                if (value < 0) {
                    throw new LexicalException("malformed escape sequence in input");
                }
                char rls = (char)this.releaseIndicator;
                if (builder.length() != 0) break block11;
                switch (code) {
                    case 69: {
                        this.peekToken.append(rls);
                        break block12;
                    }
                    case 70: {
                        this.peekToken.append(this.dataSeparator);
                        break block12;
                    }
                    case 82: {
                        this.peekToken.append((char)this.repetitionSeparator);
                        break block12;
                    }
                    case 83: {
                        this.peekToken.append(this.componentSeparator);
                        break block12;
                    }
                    case 84: {
                        this.peekToken.append((char)this.subCompSeparator);
                        break block12;
                    }
                    case 72: 
                    case 78: {
                        this.peekToken.append(rls);
                        this.peekToken.append((char)code);
                        this.peekToken.append(rls);
                        break block12;
                    }
                    default: {
                        throw new LexicalException("unsupported escape sequence code " + (char)code);
                    }
                }
            }
            throw new LexicalException("unsupported escape sequence code " + (char)code);
        }
    }

    public Integer parseSeqId() throws IOException {
        for (int i = 0; i < this.tokenBuilder.length(); ++i) {
            char chr = this.tokenBuilder.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            this.handleError(EdiConstants.DataType.INTEGER, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + chr + "' not allowed");
        }
        this.checkLength(EdiConstants.DataType.INTEGER, 1, 4);
        return Integer.valueOf(this.tokenBuilder.toString());
    }

    public String init(Map<String, Object> props) throws LexicalException {
        try {
            byte[] byts = this.readBytes(3);
            String tag = new String(byts, EdiConstants.ASCII_CHARSET);
            if (!"MSH".equals(tag)) {
                throw new RuntimeException("Message does not start with 'MSH'");
            }
            byts = this.readBytes(5);
            this.dataSeparator = (char)byts[0];
            this.componentSeparator = (char)byts[1];
            this.repetitionSeparator = (char)byts[2];
            this.releaseIndicator = (char)byts[3];
            this.subCompSeparator = (char)byts[4];
            if (this.stream.read() != this.dataSeparator) {
                throw new RuntimeException("Field separator not present following MSH-01");
            }
            this.reader = new ByteReader();
            this.advance(EdiConstants.ItemType.DATA_ELEMENT);
            this.elementNumber = 2;
            return new String(byts, EdiConstants.ASCII_CHARSET);
        }
        catch (IOException e) {
            throw new LexicalException("Message aborted due to error reading header", e);
        }
    }

    public void term(Map<String, Object> props) throws IOException {
    }

    private int parseComponent(int start, int end) throws IOException {
        int value = 0;
        for (int i = start; i < end; ++i) {
            char chr = this.tokenBuilder.charAt(i);
            if (chr < '0' || chr > '9') {
                this.handleError(EdiConstants.DataType.DATETIME, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + chr + "' not allowed");
            }
            value = value * 10 + chr - 48;
        }
        return value;
    }

    public XMLGregorianCalendar parseDateTime(int minl, int maxl, boolean zone) throws IOException {
        char sign;
        int length = this.tokenBuilder.length();
        XMLGregorianCalendar dt = this.typeFactory.newXMLGregorianCalendar();
        if (zone && length > 5 && ((sign = this.tokenBuilder.charAt(length - 5)) == '-' || sign == '+')) {
            int hours = this.parseComponent(length - 4, length - 2);
            int mins = this.parseComponent(length - 2, length);
            if (hours > 23) {
                this.handleError(EdiConstants.DataType.DATETIME, ErrorHandler.ErrorCondition.INVALID_DATE, "time zone offset hours value out of range: " + hours);
            } else if (mins > 59) {
                this.handleError(EdiConstants.DataType.DATETIME, ErrorHandler.ErrorCondition.INVALID_DATE, "time zone offset minutes value out of range: " + mins);
            } else {
                int offset = hours * 60 + mins;
                dt.setTimezone(sign == '-' ? -offset : offset);
            }
            length -= 5;
        }
        this.checkLength(EdiConstants.DataType.DATETIME, length, minl, maxl);
        if (length < 4 || length < 14 && length % 2 == 1 || length > 19) {
            this.handleError(EdiConstants.DataType.DATETIME, ErrorHandler.ErrorCondition.INVALID_DATE, "length does not match a date/time format: " + this.tokenBuilder.substring(0, length));
        }
        if (length >= 4) {
            dt.setYear(this.parseComponent(0, 4));
            if (length >= 6) {
                dt.setMonth(this.parseComponent(4, 6));
                if (length >= 8) {
                    dt.setDay(this.parseComponent(6, 8));
                    if (length >= 10) {
                        dt.setHour(this.parseComponent(8, 10));
                        if (length >= 12) {
                            dt.setMinute(this.parseComponent(10, 12));
                            if (length >= 14) {
                                dt.setSecond(this.parseComponent(12, 14));
                                if (length >= 16 && this.tokenBuilder.charAt(14) == '.') {
                                    try {
                                        dt.setFractionalSecond(new BigDecimal(this.tokenBuilder.substring(14, length)));
                                    }
                                    catch (NumberFormatException e) {
                                        this.handleError(EdiConstants.DataType.DATETIME, ErrorHandler.ErrorCondition.INVALID_DATE, "invalid second fraction: " + this.tokenBuilder.substring(0, length));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return dt;
    }

    private class ByteReader
    extends Reader {
        private ByteReader() {
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int chr;
            int actual = -1;
            while (actual < len - 1 && (chr = HL7Lexer.this.stream.read()) >= 0) {
                cbuf[off + ++actual] = (char)chr;
            }
            return actual;
        }

        @Override
        public void close() throws IOException {
            HL7Lexer.this.stream.close();
        }
    }

    public static enum InterchangeEndStatus {
        VALID,
        GROUP_COUNT_ERROR,
        CONTROL_NUMBER_ERROR;

    }
}

