/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.impl;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.value.ValueProviderService;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.context.notification.MuleContextListener;
import org.mule.runtime.core.api.data.sample.SampleDataService;
import org.mule.runtime.deployment.model.api.DeploymentStartException;
import org.mule.runtime.deployment.model.api.InstallException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.application.ApplicationPolicyManager;
import org.mule.runtime.deployment.model.api.application.ApplicationStatus;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.embedded.api.ArtifactConfiguration;
import org.mule.runtime.module.embedded.api.ContainerInfo;
import org.mule.runtime.module.embedded.impl.SerializationUtils;
import org.mule.runtime.module.launcher.MuleContainer;

public class EmbeddedController {
    private final ContainerInfo containerInfo;
    private ArtifactClassLoader containerClassLoader;
    private MuleContainer muleContainer;

    public EmbeddedController(byte[] serializedContainerInfo) throws IOException, ClassNotFoundException {
        this.containerInfo = (ContainerInfo)SerializationUtils.deserialize(serializedContainerInfo);
    }

    public void start() throws Exception {
        this.setUpEnvironment();
    }

    public synchronized void deployApplication(byte[] serializedArtifactConfiguration) throws IOException, ClassNotFoundException {
        ArtifactConfiguration artifactConfiguration = (ArtifactConfiguration)SerializationUtils.deserialize(serializedArtifactConfiguration);
        this.deployArtifactTemplateMethod(artifactConfiguration, deploymentProperties -> this.muleContainer.getDeploymentService().deploy(artifactConfiguration.getArtifactLocation().toURI(), deploymentProperties));
    }

    public void undeployApplication(byte[] serializedApplicationName) throws IOException, ClassNotFoundException {
        String applicationName = (String)SerializationUtils.deserialize(serializedApplicationName);
        this.muleContainer.getDeploymentService().undeploy(applicationName);
    }

    public synchronized void deployDomain(byte[] serializedArtifactConfiguration) throws IOException, ClassNotFoundException {
        ArtifactConfiguration artifactConfiguration = (ArtifactConfiguration)SerializationUtils.deserialize(serializedArtifactConfiguration);
        this.deployArtifactTemplateMethod(artifactConfiguration, deploymentProperties -> this.muleContainer.getDeploymentService().deployDomain(artifactConfiguration.getArtifactLocation().toURI(), deploymentProperties));
    }

    public void undeployDomain(byte[] serializedApplicationName) throws IOException, ClassNotFoundException {
        String applicationName = (String)SerializationUtils.deserialize(serializedApplicationName);
        this.muleContainer.getDeploymentService().undeployDomain(applicationName);
    }

    private void deployArtifactTemplateMethod(ArtifactConfiguration artifactConfiguration, DeploymentTask deploymentTask) {
        try {
            this.muleContainer.getDeploymentService().getLock().lock();
            Properties deploymentProperties = new Properties();
            deploymentProperties.put("mule.application.deployment.lazyInit", String.valueOf(artifactConfiguration.getDeploymentConfiguration().lazyInitializationEnabled()));
            deploymentProperties.put("mule.application.deployment.lazyInit.enableXmlValidations", String.valueOf(artifactConfiguration.getDeploymentConfiguration().xmlValidationsEnabled()));
            deploymentProperties.put("mule.application.deployment.lazyConnections", String.valueOf(artifactConfiguration.getDeploymentConfiguration().lazyConnectionsEnabled()));
            deploymentTask.deploy(deploymentProperties);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.muleContainer.getDeploymentService().getLock().isHeldByCurrentThread()) {
                this.muleContainer.getDeploymentService().getLock().unlock();
            }
        }
    }

    public void executeWithinContainerClassLoader(ContainerTask task) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.containerClassLoader.getClassLoader());
            task.run();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public void stop() {
        this.executeWithinContainerClassLoader(() -> {
            this.muleContainer.stop();
            this.muleContainer.getContainerClassLoader().dispose();
        });
    }

    private void setUpEnvironment() throws IOException, URISyntaxException {
        System.setProperty("log4j2.disable.jmx", "true");
        System.setProperty("mule.home", this.containerInfo.getContainerBaseFolder().toURI().getPath());
        MuleFoldersUtil.getDomainsFolder().mkdirs();
        MuleFoldersUtil.getDomainFolder((String)"default").mkdirs();
        MuleFoldersUtil.getServicesFolder().mkdirs();
        MuleFoldersUtil.getServerPluginsFolder().mkdirs();
        MuleFoldersUtil.getConfFolder().mkdirs();
        MuleFoldersUtil.getAppsFolder().mkdirs();
        System.setProperty("mule.mode.embedded", "true");
        for (URL url : this.containerInfo.getServices()) {
            File originalFile = FileUtils.toFile((URL)url);
            File destinationFile = new File(MuleFoldersUtil.getServicesFolder(), FilenameUtils.getName((String)originalFile.getPath()).replaceAll("-mule-service\\.jar", ""));
            destinationFile.mkdirs();
            org.mule.runtime.core.api.util.FileUtils.unzip((File)originalFile, (File)destinationFile, (boolean)false);
        }
        this.containerInfo.getServerPlugins().stream().forEach(serverPluginUrl -> {
            File originalFile = FileUtils.toFile((URL)serverPluginUrl);
            File destinationFile = new File(MuleFoldersUtil.getServerPluginsFolder(), FilenameUtils.getName((String)originalFile.getPath()).replace(".zip", ""));
            try {
                ZipFile zipFile = new ZipFile(originalFile);
                zipFile.extractAll(destinationFile.getAbsolutePath());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.muleContainer = new MuleContainer(new String[0]);
        this.muleContainer.setEmbeddedMode(true);
        this.containerClassLoader = this.muleContainer.getContainerClassLoader();
        this.executeWithinContainerClassLoader(() -> {
            try {
                this.muleContainer.start(false);
            }
            catch (MuleException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    private class NoOpApplication
    implements Application {
        private NoOpApplication() {
        }

        public RegionClassLoader getRegionClassLoader() {
            return null;
        }

        public String getArtifactName() {
            return null;
        }

        public String getArtifactId() {
            return null;
        }

        public File[] getResourceFiles() {
            return new File[0];
        }

        public ArtifactClassLoader getArtifactClassLoader() {
            return null;
        }

        public void install() throws InstallException {
        }

        public void init() {
        }

        public void lazyInit() {
        }

        public void lazyInit(boolean disableXmlValidations) {
        }

        public void start() throws DeploymentStartException {
        }

        public void stop() {
        }

        public ApplicationDescriptor getDescriptor() {
            return null;
        }

        public void dispose() {
        }

        public Registry getRegistry() {
            return null;
        }

        public ArtifactContext getArtifactContext() {
            return null;
        }

        public File getLocation() {
            return null;
        }

        public ConnectivityTestingService getConnectivityTestingService() {
            return null;
        }

        public MetadataService getMetadataService() {
            return null;
        }

        public ValueProviderService getValueProviderService() {
            return null;
        }

        public List<ArtifactPlugin> getArtifactPlugins() {
            return null;
        }

        public void setMuleContextListener(MuleContextListener muleContextListener) {
        }

        public Domain getDomain() {
            return null;
        }

        public ApplicationStatus getStatus() {
            return null;
        }

        public ApplicationPolicyManager getPolicyManager() {
            return null;
        }

        public SampleDataService getSampleDataService() {
            return null;
        }
    }

    @FunctionalInterface
    static interface ContainerTask {
        public void run() throws Exception;
    }

    @FunctionalInterface
    static interface DeploymentTask {
        public void deploy(Properties var1) throws IOException;
    }
}

