/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.worker;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.extension.socket.api.ImmutableSocketAttributes;
import org.mule.extension.socket.api.connection.tcp.protocol.EOFProtocol;
import org.mule.extension.socket.api.socket.tcp.TcpProtocol;
import org.mule.extension.socket.api.worker.SocketWorker;
import org.mule.extension.socket.internal.TcpInputStream;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TcpWorker
extends SocketWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpWorker.class);
    private final Socket socket;
    private final TcpInputStream dataIn;
    private final OutputStream dataOut;
    private final InputStream underlyingIn;
    private final TcpProtocol protocol;
    private Object notify = new Object();
    private boolean dataInWorkFinished = false;
    private AtomicBoolean moreMessages = new AtomicBoolean(true);

    public TcpWorker(Socket socket, TcpProtocol protocol, SourceCallback<InputStream, ImmutableSocketAttributes> callback) throws IOException {
        super(callback);
        this.socket = socket;
        this.protocol = protocol;
        this.underlyingIn = new BufferedInputStream(socket.getInputStream());
        this.dataOut = new BufferedOutputStream(socket.getOutputStream());
        this.dataIn = new TcpInputStream(this.underlyingIn){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                TcpWorker.this.dataInWorkFinished = true;
                TcpWorker.this.moreMessages.set(false);
                Object object = TcpWorker.this.notify;
                synchronized (object) {
                    TcpWorker.this.notify.notifyAll();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForStreams() {
        if (!this.dataInWorkFinished) {
            Object object = this.notify;
            synchronized (object) {
                if (!this.dataInWorkFinished) {
                    try {
                        this.notify.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private InputStream getNextMessage() throws IOException {
        InputStream readMsg = null;
        try {
            readMsg = this.protocol.read((InputStream)((Object)this.dataIn));
            if (this.dataIn.isStreaming()) {
                this.moreMessages.set(false);
            }
            InputStream inputStream = readMsg;
            return inputStream;
        }
        finally {
            if (readMsg == null) {
                this.dataIn.close();
            }
        }
    }

    protected void shutdownSocket() throws IOException {
        try {
            this.socket.shutdownOutput();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private boolean hasMoreMessages() {
        return !this.socket.isClosed() && !this.dataInWorkFinished && this.moreMessages.get();
    }

    @Override
    public void doRun() {
        while (this.hasMoreMessages()) {
            InputStream content;
            try {
                content = this.getNextMessage();
            }
            catch (IOException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("An error occurred while reading from the TCP Worker connection", (Throwable)e);
                }
                this.moreMessages.set(false);
                break;
            }
            if (content == null) {
                this.moreMessages.set(false);
                break;
            }
            this.handle(content, new ImmutableSocketAttributes(this.socket));
        }
    }

    @Override
    public void onComplete(InputStream result) {
        if (result == null) {
            return;
        }
        try {
            this.protocol.write(this.dataOut, result);
            this.dataOut.flush();
            if (this.protocol instanceof EOFProtocol) {
                this.releaseSocket();
            }
        }
        catch (IOException e) {
            LOGGER.error(String.format("An error occurred while sending TCP response to address '%s'", this.socket.getRemoteSocketAddress().toString()), (Throwable)e);
        }
    }

    @Override
    public void onError(Throwable e) {
        LOGGER.error("TCP worker will not answer back due an exception was received", e);
        this.moreMessages.set(false);
    }

    public void dispose() {
        this.releaseSocket();
    }

    private void releaseSocket() {
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                this.shutdownSocket();
            }
            catch (IOException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("TCP Worker shutting down output stream failed", (Throwable)e);
                }
            }
            finally {
                block14: {
                    try {
                        this.socket.close();
                    }
                    catch (IOException e) {
                        if (!LOGGER.isWarnEnabled()) break block14;
                        LOGGER.warn("TCP Worker socket close failed", (Throwable)e);
                    }
                }
            }
        }
    }
}

