/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.worker;

import java.io.InputStream;
import java.util.function.Consumer;
import org.mule.extension.socket.api.ImmutableSocketAttributes;
import org.mule.extension.socket.internal.SocketUtils;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;

public abstract class SocketWorker
implements Disposable,
Runnable {
    protected final SourceCallback<InputStream, ImmutableSocketAttributes> callback;
    private Consumer<Exception> errorHandler;

    protected SocketWorker(SourceCallback<InputStream, ImmutableSocketAttributes> callback) {
        this.callback = callback;
    }

    public void onError(Consumer<Exception> handler) {
        this.errorHandler = handler;
    }

    @Override
    public final void run() {
        try {
            this.doRun();
        }
        catch (Exception e) {
            this.errorHandler.accept(e);
        }
    }

    protected abstract void doRun() throws Exception;

    protected void handle(InputStream content, ImmutableSocketAttributes attributes) {
        SourceCallbackContext ctx = this.callback.createContext();
        ctx.addVariable("work", (Object)this);
        this.callback.handle(SocketUtils.createResult(content, attributes), ctx);
    }

    public abstract void onComplete(InputStream var1);

    public abstract void onError(Throwable var1);
}

