/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.socket.tcp;

import java.util.Objects;
import org.mule.extension.socket.api.socket.AbstractSocketProperties;
import org.mule.extension.socket.api.socket.tcp.TcpSocketProperties;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.semantics.connectivity.ExcludeFromConnectivitySchema;

public abstract class AbstractTcpSocketProperties
extends AbstractSocketProperties
implements TcpSocketProperties {
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Indicates whether the transmitted data should not be collected together for greater efficiency, and sent immediately")
    @DisplayName(value="Send TCP With No Delay")
    @ExcludeFromConnectivitySchema
    protected boolean sendTcpNoDelay;
    @Parameter
    @Optional
    @Summary(value="This indicates for how long, in milliseconds, the socket will take to close so any remaining data istransmitted correctly")
    @ExcludeFromConnectivitySchema
    protected Integer linger;
    @Parameter
    @Optional(defaultValue="false")
    @Summary(value="Indicates whether the open socket connections unused for a long period and with an unavailable connection should be closed")
    @ExcludeFromConnectivitySchema
    protected boolean keepAlive;
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Whether the socket should fail during its creation if the host set on the endpoint cannot be resolved")
    @ExcludeFromConnectivitySchema
    protected boolean failOnUnresolvedHost;

    @Override
    public Integer getLinger() {
        return this.linger;
    }

    @Override
    public boolean getKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public boolean getSendTcpNoDelay() {
        return this.sendTcpNoDelay;
    }

    @Override
    public boolean getFailOnUnresolvedHost() {
        return this.failOnUnresolvedHost;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractTcpSocketProperties that = (AbstractTcpSocketProperties)o;
        if (this.sendTcpNoDelay != that.sendTcpNoDelay) {
            return false;
        }
        if (this.keepAlive != that.keepAlive) {
            return false;
        }
        if (this.failOnUnresolvedHost != that.failOnUnresolvedHost) {
            return false;
        }
        return Objects.equals(this.linger, that.linger);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.sendTcpNoDelay ? 1 : 0);
        result = 31 * result + Objects.hashCode(this.linger);
        result = 31 * result + (this.keepAlive ? 1 : 0);
        result = 31 * result + (this.failOnUnresolvedHost ? 1 : 0);
        return result;
    }
}

