/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.socket;

import java.util.Objects;
import org.mule.extension.socket.api.socket.SocketProperties;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.semantics.connectivity.ExcludeFromConnectivitySchema;

public abstract class AbstractSocketProperties
implements SocketProperties {
    private static final String BUFFER_CONFIGURATION = "Buffer Configuration";
    protected static final String TIMEOUT_CONFIGURATION = "Timeout Configuration";
    @RefName
    protected String name;
    @Parameter
    @Optional
    @Placement(tab="Buffer Configuration")
    @Summary(value="The size of the buffer (in bytes) used when sending data")
    @ExcludeFromConnectivitySchema
    protected Integer sendBufferSize;
    @Parameter
    @Optional
    @Placement(tab="Buffer Configuration")
    @Summary(value="The size of the buffer (in bytes) used when receiving data")
    @ExcludeFromConnectivitySchema
    protected Integer receiveBufferSize;
    @Parameter
    @Optional
    @Summary(value="Time, in milliseconds, that the socket will wait in a blocking operation before failing")
    @Placement(tab="Timeout Configuration")
    @ExcludeFromConnectivitySchema
    protected Integer clientTimeout;
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Indicates whether if the configured socket could be reused or fail at when trying to bind it")
    @ExcludeFromConnectivitySchema
    private boolean reuseAddress;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Integer getSendBufferSize() {
        return this.sendBufferSize;
    }

    @Override
    public Integer getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    @Override
    public Integer getClientTimeout() {
        return this.clientTimeout;
    }

    @Override
    public boolean getReuseAddress() {
        return this.reuseAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractSocketProperties that = (AbstractSocketProperties)o;
        if (this.reuseAddress != that.reuseAddress) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.sendBufferSize, that.sendBufferSize)) {
            return false;
        }
        if (!Objects.equals(this.receiveBufferSize, that.receiveBufferSize)) {
            return false;
        }
        return Objects.equals(this.clientTimeout, that.clientTimeout);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + Objects.hashCode(this.sendBufferSize);
        result = 31 * result + Objects.hashCode(this.receiveBufferSize);
        result = 31 * result + Objects.hashCode(this.clientTimeout);
        result = 31 * result + (this.reuseAddress ? 1 : 0);
        return result;
    }
}

