/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.provider.udp;

import org.mule.extension.socket.api.SocketConnectionSettings;
import org.mule.extension.socket.api.connection.udp.UdpRequesterConnection;
import org.mule.extension.socket.api.exceptions.UnresolvableHostException;
import org.mule.extension.socket.api.socket.udp.UdpSocketProperties;
import org.mule.extension.socket.internal.SocketUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connection.PoolingConnectionProvider;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

@Alias(value="udp-requester")
public final class UdpRequesterProvider
implements PoolingConnectionProvider<UdpRequesterConnection> {
    @ParameterGroup(name="Connection")
    private SocketConnectionSettings connectionSettings;
    @ParameterGroup(name="Socket Properties")
    private UdpSocketProperties udpSocketProperties;
    @Parameter
    @Optional
    @Placement(tab="Local Address Settings")
    private SocketConnectionSettings localAddressSettings = new SocketConnectionSettings();

    public UdpRequesterConnection connect() throws ConnectionException, UnresolvableHostException {
        UdpRequesterConnection connection = new UdpRequesterConnection(this.connectionSettings, this.localAddressSettings, this.udpSocketProperties);
        connection.connect();
        return connection;
    }

    public void disconnect(UdpRequesterConnection connection) {
        connection.disconnect();
    }

    public ConnectionValidationResult validate(UdpRequesterConnection connection) {
        return SocketUtils.validate(connection);
    }
}

