/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.provider.tcp;

import org.mule.extension.socket.api.SocketConnectionSettings;
import org.mule.extension.socket.api.connection.tcp.TcpRequesterConnection;
import org.mule.extension.socket.api.connection.tcp.protocol.SafeProtocol;
import org.mule.extension.socket.api.socket.factory.SimpleSocketFactory;
import org.mule.extension.socket.api.socket.factory.SslSocketFactory;
import org.mule.extension.socket.api.socket.factory.TcpSocketFactory;
import org.mule.extension.socket.api.socket.tcp.TcpClientSocketProperties;
import org.mule.extension.socket.api.socket.tcp.TcpProtocol;
import org.mule.extension.socket.internal.SocketUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connection.PoolingConnectionProvider;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@Alias(value="tcp-requester")
public final class TcpRequesterProvider
implements PoolingConnectionProvider<TcpRequesterConnection>,
Initialisable {
    @Parameter
    @Optional
    @Placement(tab="TLS")
    @DisplayName(value="TLS Configuration")
    private TlsContextFactory tlsContext;
    @ParameterGroup(name="Connection")
    private SocketConnectionSettings connectionSettings;
    @ParameterGroup(name="Socket Properties")
    private TcpClientSocketProperties tcpClientSocketProperties;
    @Parameter
    @Optional
    @Placement(tab="Local Address Settings")
    SocketConnectionSettings localAddressSettings = new SocketConnectionSettings();
    @Parameter
    @Optional
    @Summary(value="TCP Protocol to use when doing requests")
    @Placement(tab="Connection", order=3)
    @NullSafe(defaultImplementingType=SafeProtocol.class)
    private TcpProtocol protocol;

    public TcpRequesterConnection connect() throws ConnectionException {
        SimpleSocketFactory simpleSocketFactory = null;
        try {
            simpleSocketFactory = this.tlsContext != null ? new SslSocketFactory(this.tlsContext) : new TcpSocketFactory();
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        TcpRequesterConnection connection = new TcpRequesterConnection(this.connectionSettings, this.localAddressSettings, this.protocol, this.tcpClientSocketProperties, simpleSocketFactory);
        connection.connect();
        return connection;
    }

    public void disconnect(TcpRequesterConnection connection) {
        connection.disconnect();
    }

    public ConnectionValidationResult validate(TcpRequesterConnection connection) {
        return SocketUtils.validate(connection);
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.tlsContext);
    }
}

