/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.connection.tcp.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.mule.extension.socket.api.connection.tcp.protocol.AbstractByteProtocol;
import org.mule.extension.socket.internal.SocketUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeDsl(allowTopLevelDefinition=true)
public class XmlMessageProtocol
extends AbstractByteProtocol {
    private static final String XML_PATTERN = "<?xml";
    private static final int READ_BUFFER_SIZE = 4096;
    private static final int PUSHBACK_BUFFER_SIZE = 8192;
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlMessageProtocol.class);
    private ConcurrentMap pbMap = new ConcurrentHashMap();

    public XmlMessageProtocol() {
        super(true);
    }

    @Override
    public InputStream read(InputStream socketIs) throws IOException {
        return this.nullIfEmptyArray(this.consume(socketIs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] consume(InputStream is) throws IOException {
        PushbackInputStream pbis = (PushbackInputStream)this.pbMap.get(is);
        if (null == pbis) {
            pbis = new PushbackInputStream(is, 8192);
            PushbackInputStream prev = this.pbMap.putIfAbsent(is, pbis);
            pbis = null == prev ? pbis : prev;
        }
        int len = -1;
        try {
            boolean repeat;
            byte[] buffer = new byte[4096];
            StringBuilder message = new StringBuilder(4096);
            int patternIndex = -1;
            do {
                if ((len = this.safeRead(pbis, buffer)) >= 0) {
                    message.append(new String(buffer, 0, len));
                    patternIndex = message.toString().indexOf(XML_PATTERN, 1);
                    repeat = this.isRepeat(patternIndex, len, pbis.available());
                    continue;
                }
                repeat = false;
            } while (repeat);
            if (patternIndex > 0) {
                pbis.unread(message.substring(patternIndex, message.length()).getBytes());
                message.setLength(patternIndex);
            }
            SocketUtils.logIfDebugEnabled(message.toString(), LOGGER);
            byte[] byArray = message.toString().getBytes();
            return byArray;
        }
        finally {
            if (len < 0) {
                this.pbMap.remove(is);
            }
        }
    }

    @Override
    public void write(OutputStream outputStream, InputStream data) throws IOException {
        IOUtils.copyLarge((InputStream)data, (OutputStream)outputStream);
    }

    protected boolean isRepeat(int patternIndex, int len, int available) {
        return patternIndex < 0 && len == 4096 && available > 0;
    }
}

