/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.connection.tcp.protocol;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.mule.extension.socket.api.connection.tcp.protocol.AbstractByteProtocol;
import org.mule.extension.socket.api.connection.tcp.protocol.LengthProtocol;
import org.mule.extension.socket.api.socket.tcp.TcpProtocol;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;

@TypeDsl(allowTopLevelDefinition=true)
public class SafeProtocol
extends AbstractByteProtocol {
    public static final String COOKIE = "You are using SafeProtocol";
    private final TcpProtocol cookieProtocol = new LengthProtocol("You are using SafeProtocol".length());
    private TcpProtocol delegate = new LengthProtocol();
    @DefaultEncoding
    private String muleEncoding;
    @Parameter
    @Optional(defaultValue="-1")
    private int maxMessageLeght = -1;
    @Parameter
    @Optional
    private String encoding;

    public SafeProtocol() {
        super(false);
    }

    public String getEncoding() {
        return this.encoding == null ? this.muleEncoding : this.encoding;
    }

    @Override
    public InputStream read(InputStream inputStream) throws IOException {
        if (this.assertSiblingSafe(inputStream)) {
            InputStream result = this.delegate.read(inputStream);
            if (null == result) {
                this.helpUser();
            }
            return result;
        }
        throw new IOException("Safe protocol failed while asserting message prefix");
    }

    @Override
    public void write(OutputStream os, InputStream data) throws IOException {
        this.assureSibling(os);
        this.delegate.write(os, data);
    }

    private void assureSibling(OutputStream outputStream) throws IOException {
        this.cookieProtocol.write(outputStream, new ByteArrayInputStream(COOKIE.getBytes(this.getEncoding())));
    }

    private boolean assertSiblingSafe(InputStream inputStream) throws IOException {
        InputStream cookie = null;
        try {
            cookie = this.cookieProtocol.read(inputStream);
        }
        catch (Exception e) {
            this.helpUser(e);
        }
        if (null != cookie) {
            String parsedCookie = IOUtils.toString((InputStream)cookie, (String)this.getEncoding());
            if (parsedCookie.length() != COOKIE.length() || !COOKIE.equals(parsedCookie)) {
                this.helpUser();
            } else {
                return true;
            }
        }
        return false;
    }

    private void helpUser() throws IOException {
        throw new IOException("You are not using a consistent protocol on your TCP transport. Please read the documentation for the TCP transport, paying particular attention to the protocol parameter.");
    }

    private void helpUser(Exception e) throws IOException {
        throw (IOException)new IOException("An error occurred while verifying your connection.  You may not be using a consistent protocol on your TCP transport. Please read the documentation for the TCP transport, paying particular attention to the protocol parameter.").initCause(e);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SafeProtocol that = (SafeProtocol)o;
        return this.maxMessageLeght == that.maxMessageLeght && Objects.equals(this.cookieProtocol, that.cookieProtocol) && Objects.equals(this.delegate, that.delegate) && Objects.equals(this.muleEncoding, that.muleEncoding) && Objects.equals(this.encoding, that.encoding);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.cookieProtocol, this.delegate, this.muleEncoding, this.maxMessageLeght, this.encoding);
    }
}

