/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.connection.tcp.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.mule.extension.socket.api.connection.tcp.protocol.AbstractByteProtocol;
import org.mule.extension.socket.internal.SocketUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeDsl(allowTopLevelDefinition=true)
public class DirectProtocol
extends AbstractByteProtocol {
    protected static final int UNLIMITED = -1;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectProtocol.class);
    protected int bufferSize;

    public DirectProtocol() {
        this(true, 8192);
    }

    public DirectProtocol(boolean streamOk, int bufferSize) {
        super(streamOk);
        this.bufferSize = bufferSize;
    }

    @Override
    public InputStream read(InputStream socketIs) throws IOException {
        return this.nullIfEmptyArray(this.consume(socketIs, -1));
    }

    protected byte[] consume(InputStream is, int limit) throws IOException {
        int len;
        boolean repeat;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.bufferSize);
        byte[] buffer = new byte[this.bufferSize];
        int remain = this.remaining(limit, limit, 0);
        do {
            len = this.copy(is, buffer, (OutputStream)byteArrayOutputStream, remain);
            SocketUtils.logIfDebugEnabled(buffer, LOGGER);
            remain = this.remaining(limit, remain, len);
        } while (repeat = -1 != len && remain > 0 && this.isRepeat(len, is.available()));
        byteArrayOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    protected int remaining(int limit, int remain, int len) {
        if (-1 == limit) {
            return this.bufferSize;
        }
        if (-1 != len) {
            return remain - len;
        }
        return remain;
    }

    protected boolean isRepeat(int len, int available) {
        return available > 0;
    }

    @Override
    public void write(OutputStream outputStream, InputStream data) throws IOException {
        IOUtils.copyLarge((InputStream)data, (OutputStream)outputStream, (int)this.bufferSize);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DirectProtocol that = (DirectProtocol)o;
        return this.bufferSize == that.bufferSize;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bufferSize);
    }
}

