/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.connection.tcp.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.mule.extension.socket.api.socket.tcp.TcpProtocol;
import org.mule.extension.socket.internal.SocketUtils;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeDsl(allowTopLevelDefinition=true)
public class CustomProtocol
implements TcpProtocol {
    @Parameter
    @Alias(value="class")
    @Summary(value="Full qualifier class name that must implement 'TcpProtocol' that will be used as a custom protocol")
    @DisplayName(value="Protocol Class Name")
    private String clazz;
    private LazyValue<TcpProtocol> delegate = new LazyValue(this::createProtocol);
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomProtocol.class);

    @Override
    public InputStream read(InputStream is) throws IOException {
        return ((TcpProtocol)this.delegate.get()).read(SocketUtils.logIfDebugEnabled(is, LOGGER));
    }

    @Override
    public void write(OutputStream os, InputStream data) throws IOException {
        ((TcpProtocol)this.delegate.get()).write(os, SocketUtils.logIfDebugEnabled(data, LOGGER));
    }

    private TcpProtocol createProtocol() {
        try {
            return (TcpProtocol)ClassUtils.instantiateClass((String)this.clazz, (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not load class '%s'", this.clazz), e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomProtocol that = (CustomProtocol)o;
        return Objects.equals(this.clazz, that.clazz) && Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.clazz, this.delegate);
    }
}

