/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.connection.tcp.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.mule.extension.socket.api.connection.tcp.protocol.LengthProtocol;
import org.mule.extension.socket.internal.SocketUtils;
import org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeDsl(allowTopLevelDefinition=true)
public class CustomClassLoadingLengthProtocol
extends LengthProtocol {
    @Parameter
    @Optional
    private ClassLoader classLoader;
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomClassLoadingLengthProtocol.class);

    @Override
    public InputStream read(InputStream is) throws IOException {
        return new ClassLoaderObjectInputStream(this.getClassLoader(), SocketUtils.logIfDebugEnabled(is, LOGGER));
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomClassLoadingLengthProtocol that = (CustomClassLoadingLengthProtocol)o;
        return Objects.equals(this.classLoader, that.classLoader);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.classLoader);
    }
}

