/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.connection.tcp;

import java.io.IOException;
import java.net.Socket;
import org.mule.extension.socket.api.SocketConnectionSettings;
import org.mule.extension.socket.api.client.TcpClient;
import org.mule.extension.socket.api.connection.RequesterConnection;
import org.mule.extension.socket.api.connection.tcp.AbstractTcpConnection;
import org.mule.extension.socket.api.socket.factory.SimpleSocketFactory;
import org.mule.extension.socket.api.socket.tcp.TcpClientSocketProperties;
import org.mule.extension.socket.api.socket.tcp.TcpProtocol;
import org.mule.extension.socket.internal.SocketUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;

public class TcpRequesterConnection
extends AbstractTcpConnection
implements RequesterConnection {
    private Socket socket;
    private final TcpClientSocketProperties socketProperties;
    private final SocketConnectionSettings localAddressSettings;
    private final SimpleSocketFactory socketFactory;

    public TcpRequesterConnection(SocketConnectionSettings connectionSettings, SocketConnectionSettings localAddressSettings, TcpProtocol protocol, TcpClientSocketProperties socketProperties, SimpleSocketFactory socketFactory) throws ConnectionException {
        super(connectionSettings, protocol);
        this.socketProperties = socketProperties;
        this.socketFactory = socketFactory;
        this.localAddressSettings = localAddressSettings;
    }

    @Override
    public TcpClient getClient() {
        return new TcpClient(this.socket, this.protocol);
    }

    @Override
    public void doDisconnect() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            this.LOGGER.error("An error occurred when  closing TCP requester socket", (Throwable)e);
        }
    }

    @Override
    public void connect() throws ConnectionException {
        try {
            this.socket = this.socketFactory.createSocket();
            SocketUtils.configureConnection(this.socket, this.socketProperties);
            this.socket.bind(this.localAddressSettings.getInetSocketAddress());
            this.socket.connect(this.getSocketAddress(this.connectionSettings, this.socketProperties.getFailOnUnresolvedHost()), this.socketProperties.getConnectionTimeout());
        }
        catch (Exception e) {
            throw new ConnectionException(String.format("Could not connect TCP requester socket to host '%s' on port '%d'", this.connectionSettings.getHost(), this.connectionSettings.getPort()), (Throwable)e);
        }
    }

    @Override
    public ConnectionValidationResult validate() {
        if (!this.socket.isBound()) {
            return ConnectionValidationResult.failure((String)"TCP client socket was not bounded", null);
        }
        if (!this.socket.isConnected()) {
            return ConnectionValidationResult.failure((String)"TCP client socket was not connected", null);
        }
        if (this.socket.isClosed()) {
            return ConnectionValidationResult.failure((String)"TCP client socket was closed", null);
        }
        return ConnectionValidationResult.success();
    }
}

