/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.mule.extension.socket.api.ImmutableSocketAttributes;
import org.mule.extension.socket.api.SocketAttributes;
import org.mule.extension.socket.api.client.SocketClient;
import org.mule.extension.socket.api.connection.tcp.protocol.EOFProtocol;
import org.mule.extension.socket.api.socket.tcp.TcpProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TcpClient
implements SocketClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpClient.class);
    private final Socket socket;
    private final TcpProtocol protocol;

    public TcpClient(Socket socket, TcpProtocol protocol) {
        this.socket = socket;
        this.protocol = protocol;
    }

    @Override
    public void write(InputStream data) throws IOException {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.socket.getOutputStream());
            this.protocol.write(bufferedOutputStream, data);
            bufferedOutputStream.flush();
        }
        finally {
            data.close();
            if (this.protocol instanceof EOFProtocol) {
                this.socket.shutdownOutput();
            }
        }
    }

    @Override
    public InputStream read() throws IOException {
        DataInputStream inputStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        return this.protocol.read(inputStream);
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    @Override
    public SocketAttributes getAttributes() {
        return new ImmutableSocketAttributes(this.socket);
    }
}

