/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import org.mule.extension.socket.api.ImmutableSocketAttributes;
import org.mule.extension.socket.api.client.SocketClient;
import org.mule.extension.socket.api.connection.RequesterConnection;
import org.mule.extension.socket.api.exceptions.SocketsErrorTypeProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;

@Throws(value={SocketsErrorTypeProvider.class})
public class SocketOperations {
    @MediaType(value="*/*", strict=false)
    public Result<InputStream, ImmutableSocketAttributes> sendAndReceive(@Connection RequesterConnection connection, @Content InputStream content) throws ConnectionException, IOException {
        try {
            SocketClient client = connection.getClient();
            client.write(content);
            return Result.builder().output((Object)client.read()).attributes((Object)((ImmutableSocketAttributes)client.getAttributes())).build();
        }
        catch (SocketException connException) {
            throw new ConnectionException(String.format("Socket write/read operation failed: %s.", connException.getMessage()), (Throwable)connException, null, (Object)connection);
        }
    }

    public void send(@Connection RequesterConnection connection, @Content InputStream content) throws ConnectionException, IOException {
        try {
            connection.getClient().write(content);
        }
        catch (SocketException connException) {
            throw new ConnectionException(String.format("Socket write operation failed: %s.", connException.getMessage()), (Throwable)connException, null, (Object)connection);
        }
    }
}

