/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.api.security.configuration;

import static java.lang.String.format;

/**
 * Represents the identifier of a part of a SOAP message to be signed or encrypted.
 *
 * @since 1.1
 */
public class WssPart {

  private static final String SOAP_PART_IDENTIFIER_FORMAT = "{%s}{%s}%s;";

  private String encode;

  private String namespace;

  private String localname;

  public WssPart(String encode, String namespace, String localname) {
    this.encode = encode;
    this.namespace = namespace;
    this.localname = localname;
  }

  public String getEncode() {
    return encode;
  }

  public String getNamespace() {
    return namespace;
  }

  public String getLocalname() {
    return localname;
  }

  @Override
  public String toString() {
    return format(SOAP_PART_IDENTIFIER_FORMAT,
                  encode != null ? encode : "",
                  namespace != null ? namespace : "",
                  localname != null ? localname : "");
  }

}
