/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.client;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.soap.interceptor.CheckFaultInterceptor;
import org.apache.cxf.binding.soap.interceptor.Soap11FaultInInterceptor;
import org.apache.cxf.binding.soap.interceptor.Soap12FaultInInterceptor;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.apache.cxf.ws.addressing.impl.MAPAggregatorImpl;
import org.apache.cxf.ws.addressing.soap.MAPCodec;
import org.apache.cxf.ws.rm.RMCaptureInInterceptor;
import org.apache.cxf.ws.rm.RMDeliveryInterceptor;
import org.apache.cxf.ws.rm.RMInInterceptor;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMOutInterceptor;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.soap.RMSoapInInterceptor;
import org.apache.cxf.ws.rm.soap.RMSoapOutInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.apache.cxf.wsdl.interceptors.WrappedOutInterceptor;
import org.mule.soap.api.SoapVersion;
import org.mule.soap.api.SoapWebServiceConfiguration;
import org.mule.soap.api.rm.ReliableMessagingConfiguration;
import org.mule.soap.api.security.SecurityStrategy;
import org.mule.soap.internal.client.CxfClientFactory;
import org.mule.soap.internal.interceptor.MuleRMCaptureOutInterceptor;
import org.mule.soap.internal.interceptor.OutputMtomSoapAttachmentsInterceptor;
import org.mule.soap.internal.interceptor.OutputSoapHeadersInterceptor;
import org.mule.soap.internal.interceptor.SkipAddressingInInterceptor;
import org.mule.soap.internal.interceptor.SkipAddressingOutInterceptor;
import org.mule.soap.internal.interceptor.SkipReliableMessagingInInterceptor;
import org.mule.soap.internal.interceptor.SkipReliableMessagingOutInterceptor;
import org.mule.soap.internal.interceptor.SoapActionInterceptor;
import org.mule.soap.internal.interceptor.StreamClosingInterceptor;
import org.mule.soap.internal.rm.MuleRMManager;
import org.mule.soap.internal.rm.store.RMStoreImp;
import org.mule.soap.internal.security.callback.CompositeCallbackHandler;

class CxfClientProvider {
    private final CxfClientFactory factory = new CxfClientFactory();

    CxfClientProvider() {
    }

    Client getClient(SoapWebServiceConfiguration configuration) {
        boolean isMtom = configuration.isMtomEnabled();
        String address = configuration.getAddress();
        SoapVersion version = configuration.getVersion();
        Client client = this.factory.createClient(address, version.getNumber());
        this.addSecurityInterceptors(client, configuration.getSecurities());
        this.addRequestInterceptors(client);
        this.addResponseInterceptors(client);
        this.addAddressingInterceptors(client);
        this.addReliableMessagingInterceptors(client);
        client.getEndpoint().put((Object)"mtom-enabled", (Object)isMtom);
        configuration.getReliableMessagingConfiguration().ifPresent(config -> this.configureReliableMessaging(client, (ReliableMessagingConfiguration)config));
        this.removeUnnecessaryCxfInterceptors(client);
        return client;
    }

    private void addSecurityInterceptors(Client client, List<SecurityStrategy> securityStrategies) {
        Map<String, Object> responseProps;
        Map<String, Object> requestProps = this.buildSecurityProperties(securityStrategies, SecurityStrategy.SecurityStrategyType.OUTGOING);
        if (!requestProps.isEmpty() && StringUtils.isNotBlank((CharSequence)((String)requestProps.get("action")))) {
            client.getOutInterceptors().add(new WSS4JOutInterceptor(requestProps));
        }
        if (!(responseProps = this.buildSecurityProperties(securityStrategies, SecurityStrategy.SecurityStrategyType.INCOMING)).isEmpty() && StringUtils.isNotBlank((CharSequence)((String)responseProps.get("action")))) {
            client.getInInterceptors().add(new WSS4JInInterceptor(responseProps));
        }
    }

    private Map<String, Object> buildSecurityProperties(List<SecurityStrategy> strategies, SecurityStrategy.SecurityStrategyType type) {
        String actions;
        if (strategies.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        StringJoiner actionsJoiner = new StringJoiner(" ");
        ImmutableList.Builder callbackHandlersBuilder = ImmutableList.builder();
        strategies.stream().filter(strategy -> strategy.securityType().equals((Object)type) || strategy.securityType().equals((Object)SecurityStrategy.SecurityStrategyType.ALWAYS)).forEach(securityStrategy -> {
            props.putAll(securityStrategy.buildSecurityProperties());
            if (StringUtils.isNotBlank((CharSequence)securityStrategy.securityAction())) {
                actionsJoiner.add(securityStrategy.securityAction());
            }
            securityStrategy.buildPasswordCallbackHandler().ifPresent(arg_0 -> ((ImmutableList.Builder)callbackHandlersBuilder).add(arg_0));
        });
        ImmutableList handlers = callbackHandlersBuilder.build();
        if (!handlers.isEmpty()) {
            props.put("passwordCallbackRef", new CompositeCallbackHandler((List<CallbackHandler>)handlers));
        }
        if (StringUtils.isNotBlank((CharSequence)(actions = actionsJoiner.toString()))) {
            props.put("action", actions);
        }
        return props;
    }

    private void addRequestInterceptors(Client client) {
        List outInterceptors = client.getOutInterceptors();
        outInterceptors.add(new SoapActionInterceptor());
    }

    private void addResponseInterceptors(Client client) {
        List inInterceptors = client.getInInterceptors();
        inInterceptors.add(new StreamClosingInterceptor());
        inInterceptors.add(new CheckFaultInterceptor());
        inInterceptors.add(new OutputSoapHeadersInterceptor());
        inInterceptors.add(new SoapActionInterceptor());
        inInterceptors.add(new OutputMtomSoapAttachmentsInterceptor());
    }

    private void removeUnnecessaryCxfInterceptors(Client client) {
        Binding binding = client.getEndpoint().getBinding();
        this.removeInterceptor(binding.getOutInterceptors(), WrappedOutInterceptor.class.getName());
        this.removeInterceptor(binding.getInInterceptors(), Soap11FaultInInterceptor.class.getName());
        this.removeInterceptor(binding.getInInterceptors(), Soap12FaultInInterceptor.class.getName());
        this.removeInterceptor(binding.getInInterceptors(), CheckFaultInterceptor.class.getName());
    }

    private void removeInterceptor(List<Interceptor<? extends Message>> inInterceptors, String name) {
        inInterceptors.removeIf(i -> i instanceof PhaseInterceptor && ((PhaseInterceptor)i).getId().equals(name));
    }

    private void addAddressingInterceptors(Client client) {
        WSAddressingFeature feature = new WSAddressingFeature();
        MAPCodec mapCodec = MAPCodec.getInstance((Bus)client.getBus());
        MAPAggregatorImpl mapAggregator = new MAPAggregatorImpl();
        SkipAddressingInInterceptor inInterceptor = new SkipAddressingInInterceptor(mapCodec, mapAggregator);
        SkipAddressingOutInterceptor outInterceptor = new SkipAddressingOutInterceptor(mapCodec, mapAggregator);
        mapAggregator.setAllowDuplicates(feature.isAllowDuplicates());
        mapAggregator.setUsingAddressingAdvisory(feature.isUsingAddressingAdvisory());
        mapAggregator.setAddressingRequired(feature.isAddressingRequired());
        if (feature.getMessageIdCache() != null) {
            mapAggregator.setMessageIdCache(feature.getMessageIdCache());
        }
        client.getInInterceptors().add(mapAggregator);
        client.getInInterceptors().add(mapCodec);
        client.getInInterceptors().add(inInterceptor);
        client.getOutInterceptors().add(mapAggregator);
        client.getOutInterceptors().add(mapCodec);
        client.getOutInterceptors().add(outInterceptor);
        client.getInFaultInterceptors().add(mapAggregator);
        client.getInFaultInterceptors().add(mapCodec);
        client.getInFaultInterceptors().add(inInterceptor);
        client.getOutFaultInterceptors().add(mapAggregator);
        client.getOutFaultInterceptors().add(mapCodec);
        client.getOutFaultInterceptors().add(outInterceptor);
    }

    private void addReliableMessagingInterceptors(Client client) {
        Bus bus = client.getBus();
        MuleRMManager manager = new MuleRMManager((RMManager)bus.getExtension(RMManager.class));
        manager.getSourcePolicy().getSequenceTerminationPolicy().setTerminateOnShutdown(false);
        bus.setExtension((Object)manager, RMManager.class);
        RMInInterceptor rmLogicalIn = new RMInInterceptor();
        RMOutInterceptor rmLogicalOut = new RMOutInterceptor();
        RMDeliveryInterceptor rmDelivery = new RMDeliveryInterceptor();
        RMSoapOutInterceptor rmOutCodec = new RMSoapOutInterceptor();
        RMSoapInInterceptor rmInCodec = new RMSoapInInterceptor();
        RMCaptureInInterceptor rmCaptureIn = new RMCaptureInInterceptor();
        MuleRMCaptureOutInterceptor rmCaptureOut = new MuleRMCaptureOutInterceptor();
        SkipReliableMessagingOutInterceptor outInterceptor = new SkipReliableMessagingOutInterceptor(rmLogicalOut, rmOutCodec, rmCaptureOut);
        SkipReliableMessagingInInterceptor inInterceptor = new SkipReliableMessagingInInterceptor(rmLogicalIn, rmDelivery, rmInCodec, rmCaptureIn);
        rmLogicalIn.setBus(bus);
        rmLogicalOut.setBus(bus);
        rmDelivery.setBus(bus);
        rmCaptureIn.setBus(bus);
        rmCaptureOut.setBus(bus);
        client.getInInterceptors().add(rmLogicalIn);
        client.getInInterceptors().add(rmInCodec);
        client.getInInterceptors().add(rmDelivery);
        client.getInInterceptors().add(rmCaptureIn);
        client.getInInterceptors().add(inInterceptor);
        client.getOutInterceptors().add(rmLogicalOut);
        client.getOutInterceptors().add(rmOutCodec);
        client.getOutInterceptors().add(rmCaptureOut);
        client.getOutInterceptors().add(outInterceptor);
        client.getInFaultInterceptors().add(rmLogicalIn);
        client.getInFaultInterceptors().add(rmInCodec);
        client.getInFaultInterceptors().add(rmDelivery);
        client.getInFaultInterceptors().add(inInterceptor);
        client.getOutFaultInterceptors().add(rmLogicalOut);
        client.getOutFaultInterceptors().add(rmOutCodec);
        client.getOutFaultInterceptors().add(rmCaptureOut);
        client.getOutFaultInterceptors().add(outInterceptor);
    }

    private void configureReliableMessaging(Client client, ReliableMessagingConfiguration config) {
        RMManager manager = (RMManager)client.getBus().getExtension(RMManager.class);
        manager.setStore((RMStore)new RMStoreImp(config.getStore()));
        manager.clientCreated(client);
    }
}

