/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.internal.rm.store;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.v200702.Identifier;

public class SourceSequenceTransfer implements Serializable {

  private long currentMessageNumber;
  private boolean lastMessage;
  private long expiry;
  private String offeringIdValue;
  private String endpointIdentifier;
  private String encodedProtocolVersion;
  private List<MessageTransfer> messageTransfers;

  public SourceSequenceTransfer(SourceSequence sourceSequence) {
    this.currentMessageNumber = sourceSequence.getCurrentMessageNr();
    this.lastMessage = sourceSequence.isLastMessage();

    Date expiryDate = sourceSequence.getExpires();
    this.expiry = expiryDate == null ? 0 : expiryDate.getTime();

    Identifier offeringId = sourceSequence.getOfferingSequenceIdentifier();
    this.offeringIdValue = offeringId == null ? null : offeringId.getValue();

    this.endpointIdentifier = sourceSequence.getSource() == null ? null : sourceSequence.getEndpointIdentifier();
    this.encodedProtocolVersion = encodeProtocolVersion(sourceSequence.getProtocol());
    this.messageTransfers = new ArrayList<>();
  }

  public long getCurrentMessageNumber() {
    return currentMessageNumber;
  }

  public void setCurrentMessageNumber(long currentMessageNumber) {
    this.currentMessageNumber = currentMessageNumber;
  }

  public boolean isLastMessage() {
    return lastMessage;
  }

  public void setLastMessage(boolean lastMessage) {
    this.lastMessage = lastMessage;
  }

  public long getExpiry() {
    return expiry;
  }

  public void setExpiry(long expiry) {
    this.expiry = expiry;
  }

  public String getOfferingIdValue() {
    return offeringIdValue;
  }

  public void setOfferingIdValue(String offeringIdValue) {
    this.offeringIdValue = offeringIdValue;
  }

  public String getEndpointIdentifier() {
    return endpointIdentifier;
  }

  public void setEndpointIdentifier(String endpointIdentifier) {
    this.endpointIdentifier = endpointIdentifier;
  }

  public String getEncodedProtocolVersion() {
    return encodedProtocolVersion;
  }

  public void setEncodedProtocolVersion(String encodedProtocolVersion) {
    this.encodedProtocolVersion = encodedProtocolVersion;
  }

  public List<MessageTransfer> getMessageTransfers() {
    return messageTransfers;
  }

  public void setMessageTransfers(ArrayList<MessageTransfer> messageTransfers) {
    this.messageTransfers = messageTransfers;
  }

  public void addMessageTransfer(MessageTransfer messageTransfer) {
    this.messageTransfers.add(messageTransfer);
  }

  private String encodeProtocolVersion(ProtocolVariation protocolVariation) {
    return protocolVariation.getCodec().getWSRMNamespace() + ' ' + protocolVariation.getCodec().getWSANamespace();
  }

}
