/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.internal.message;

import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.api.message.SoapResponse;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

import static java.util.Collections.emptyMap;
import static java.util.Collections.unmodifiableMap;

/**
 * Empty {@link SoapResponse} implementation.
 *
 * @since 1.0
 */
public final class EmptySoapResponse implements SoapResponse {

  private final Map<String, String> transportHeaders;
  private final Map<String, String> transportAdditionalData;

  public EmptySoapResponse(Map<String, String> transportHeaders, Map<String, String> transportAdditionalData) {
    this.transportHeaders = unmodifiableMap(transportHeaders);
    this.transportAdditionalData = unmodifiableMap(transportAdditionalData);
  }

  @Override
  public InputStream getContent() {
    return new ByteArrayInputStream(new byte[0]);
  }

  @Override
  public Map<String, String> getSoapHeaders() {
    return emptyMap();
  }

  @Override
  public Map<String, String> getTransportHeaders() {
    return transportHeaders;
  }

  @Override
  public Map<String, String> getTransportAdditionalData() {
    return transportAdditionalData;
  }

  @Override
  public Map<String, SoapAttachment> getAttachments() {
    return emptyMap();
  }

  @Override
  public String getContentType() {
    return "*/*";
  }
}
