/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.conduit;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.EndpointReferenceUtils;
import org.mule.soap.internal.conduit.SoapServiceConduit;

public class SoapServiceConduitInitiator
implements ConduitInitiator {
    public static final String[] SOAP_SERVICE_KNOWN_PROTOCOLS = new String[]{"http://", "https://", "jms://"};

    public Conduit getConduit(EndpointInfo targetInfo, Bus bus) {
        return this.getConduit(targetInfo, null, bus);
    }

    public Conduit getConduit(EndpointInfo localInfo, EndpointReferenceType target, Bus bus) {
        return new SoapServiceConduit(this.getTargetReference(localInfo, target));
    }

    public Set<String> getUriPrefixes() {
        return new HashSet<String>(Arrays.asList(SOAP_SERVICE_KNOWN_PROTOCOLS));
    }

    public List<String> getTransportIds() {
        return Stream.of("http://schemas.xmlsoap.org/soap/http").collect(Collectors.toList());
    }

    private EndpointReferenceType getTargetReference(EndpointInfo endpointInfo, EndpointReferenceType referenceType) {
        if (referenceType != null) {
            return referenceType;
        }
        EndpointReferenceType ref = new EndpointReferenceType();
        AttributedURIType address = new AttributedURIType();
        address.setValue(endpointInfo.getAddress());
        ref.setAddress(address);
        if (endpointInfo.getService() != null) {
            EndpointReferenceUtils.setServiceAndPortName((EndpointReferenceType)ref, (QName)endpointInfo.getService().getName(), (String)endpointInfo.getName().getLocalPart());
        }
        return ref;
    }
}

