/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.api.client;

import java.util.Map;

/**
 * {@link RuntimeException} implementation that aims to be thrown when an error occur while parsing or processing a SOAP response
 * that does not contain the mandatory fields.
 *
 * @since 1.0
 */
public final class EmptyResponseException extends BadResponseException {

  public EmptyResponseException(String message) {
    super(message);
  }

  public EmptyResponseException(String message, Throwable cause) {
    super(message, cause);
  }

  public EmptyResponseException(String message, Throwable cause, Map<String, String> additionalTransportData) {
    super(message, cause, additionalTransportData);
  }
}
