/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.api.message;

import java.io.InputStream;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Represents an attachment that was sent or received using the SOAP protocol, MTOM or SWA.
 *
 * @since 1.0
 */
public class SoapAttachment implements WithContentType {

  private InputStream content;
  private String contentType;

  public SoapAttachment(InputStream content, String contentType) {
    checkNotNull(content, "Content cannot be null");
    checkNotNull(contentType, "Content Type cannot be null");
    this.content = content;
    this.contentType = contentType;
  }

  public SoapAttachment() {}

  public InputStream getContent() {
    return this.content;
  }

  @Override
  public String getContentType() {
    return this.contentType;
  }
}
