/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.api.client;

import java.util.Map;

/**
 * {@link RuntimeException} implementation that aims to be thrown when an error occur while parsing or processing a SOAP response.
 *
 * @since 1.0
 */
public class BadResponseException extends RuntimeException {

  private Map<String, String> additionalTransportData;

  public BadResponseException(String message) {
    super(message);
  }

  public BadResponseException(String message, Throwable cause) {
    super(message, cause);
  }

  public BadResponseException(String message, Throwable cause, Map<String, String> additionalTransportData) {
    super(message, cause);
    this.additionalTransportData = additionalTransportData;
  }
}
