/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.rm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.persistence.RMMessage;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;
import org.mule.soap.internal.rm.ForwardingRMManager;
import org.mule.soap.internal.rm.RMUtils;

public class MuleRMManager
extends ForwardingRMManager {
    private static final long RM_MESSAGE_NUMBER = -1L;

    public MuleRMManager(RMManager manager) {
        super(manager);
    }

    @Override
    public SourceSequence getSequence(Identifier inSeqId, Message message, AddressingProperties maps) throws RMException {
        String sequenceIdentifier = RMUtils.getReliableMessagingSequence(message);
        if (!StringUtils.isBlank((CharSequence)sequenceIdentifier)) {
            Identifier identifier = new Identifier();
            identifier.setValue(sequenceIdentifier);
            return super.getSource(message).getSequence(identifier);
        }
        return super.getSequence(inSeqId, message, maps);
    }

    @Override
    public void clientCreated(Client client) {
        List<Identifier> sequences = this.preClientCreated(client);
        super.clientCreated(client);
        this.postClientCreated(client, sequences);
    }

    private List<Identifier> preClientCreated(Client client) {
        ArrayList<Identifier> sequences = new ArrayList<Identifier>();
        if (this.getStore() != null && this.getRetransmissionQueue() != null) {
            String id = org.apache.cxf.ws.rm.RMUtils.getEndpointIdentifier((Endpoint)client.getEndpoint(), (Bus)this.getBus());
            Collection sss = this.getStore().getSourceSequences(id);
            if (null != sss && !sss.isEmpty()) {
                RMMessage message = this.createRMMessage();
                for (SourceSequence ss : sss) {
                    Collection messages = this.getStore().getMessages(ss.getIdentifier(), true);
                    if (messages != null && !messages.isEmpty()) continue;
                    this.getStore().persistOutgoing(ss, message);
                    sequences.add(ss.getIdentifier());
                }
            }
        }
        return sequences;
    }

    private void postClientCreated(Client client, List<Identifier> sequences) {
        if (sequences == null || sequences.isEmpty()) {
            return;
        }
        SequenceAcknowledgement emptyAck = org.apache.cxf.ws.rm.RMUtils.getWSRMFactory().createSequenceAcknowledgement();
        SequenceAcknowledgement ack = this.createSequenceAcknowledgement();
        RMEndpoint rmEndpoint = super.findReliableEndpoint(client.getEndpoint().getService().getName());
        for (Identifier sequenceId : sequences) {
            SourceSequence sequence = rmEndpoint.getSource().getSequence(sequenceId);
            try {
                sequence.setAcknowledged(ack);
                sequence.setAcknowledged(emptyAck);
            }
            catch (RMException e) {
                throw new RuntimeException("Error trying to recover RM state.", e);
            }
        }
    }

    private RMMessage createRMMessage() {
        RMMessage message = new RMMessage();
        message.setMessageNumber(-1L);
        message.setContent(new CachedOutputStream());
        return message;
    }

    private SequenceAcknowledgement createSequenceAcknowledgement() {
        SequenceAcknowledgement.AcknowledgementRange range = org.apache.cxf.ws.rm.RMUtils.getWSRMFactory().createSequenceAcknowledgementAcknowledgementRange();
        range.setLower(Long.valueOf(-1L));
        range.setUpper(Long.valueOf(-1L));
        SequenceAcknowledgement ack = org.apache.cxf.ws.rm.RMUtils.getWSRMFactory().createSequenceAcknowledgement();
        ack.getAcknowledgementRange().add(range);
        return ack;
    }
}

