/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.interceptor.gzip;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;

public abstract class AbstractProxyGZIPInterceptor
extends AbstractPhaseInterceptor<Message> {
    public AbstractProxyGZIPInterceptor(String phase) {
        super(phase);
    }

    protected boolean isEncoded(Message message) {
        boolean isEncoded = false;
        Map headers = (Map)message.getExchange().get((Object)"mule.soap.transport.headers");
        Optional header = Optional.ofNullable(headers.get("Content-Encoding"));
        if (!header.isPresent()) {
            header = Optional.ofNullable(headers.get("Content-Encoding".toLowerCase()));
        }
        if (!header.isPresent()) {
            header = Optional.ofNullable(headers.get("SOAPJMS_contentEncoding"));
        }
        if (header.isPresent()) {
            List<String> encodings = Arrays.asList(GZIPOutInterceptor.ENCODINGS.split(((String)header.get()).trim()));
            isEncoded = encodings.contains("gzip") || encodings.contains("x-gzip");
        }
        return isEncoded;
    }
}

