/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.generator.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;
import org.mule.soap.api.client.BadRequestException;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.internal.util.CopyStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AttachmentRequestEnricher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentRequestEnricher.class);
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private static final XMLEventFactory XML_EVENT_FACTORY = XMLEventFactory.newInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLStreamReader enrichRequest(String operation, InputStream body, String encoding, Map<String, SoapAttachment> attachments) throws XMLStreamException {
        CopyStream outputByteStream = new CopyStream();
        XMLEventReader xmlEventReader = null;
        XMLEventWriter xmlEventWriter = null;
        try {
            try {
                xmlEventReader = XML_INPUT_FACTORY.createXMLEventReader(body, encoding);
                xmlEventWriter = XML_OUTPUT_FACTORY.createXMLEventWriter(outputByteStream);
                LinkedHashSet<String> addedAttachments = new LinkedHashSet<String>();
                while (xmlEventReader.hasNext()) {
                    XMLEvent xmlEvent = xmlEventReader.nextEvent();
                    if (xmlEvent.isEndElement() && xmlEvent.asEndElement().getName().getLocalPart().equals(operation)) {
                        for (String key : attachments.keySet()) {
                            if (addedAttachments.contains(key)) continue;
                            this.writeAttachmentStart(xmlEventWriter, key);
                            this.writeAttachmentContent(xmlEventWriter, key, attachments.get(key));
                            this.writeAttachmentEnd(xmlEventWriter, key);
                        }
                        xmlEventWriter.add(xmlEvent);
                        continue;
                    }
                    String attachmentName = this.getAttachmentName(xmlEvent);
                    if (StringUtils.isNotBlank((CharSequence)attachmentName) && !addedAttachments.contains(attachmentName) && attachments.containsKey(attachmentName)) {
                        this.writeAttachmentContent(xmlEventWriter, attachmentName, attachments.get(attachmentName));
                        addedAttachments.add(attachmentName);
                        continue;
                    }
                    xmlEventWriter.add(xmlEvent);
                }
                xmlEventWriter.flush();
            }
            finally {
                try {
                    body.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Could not close body InputStream", (Throwable)e);
                }
                try {
                    if (xmlEventWriter != null) {
                        xmlEventWriter.close();
                    }
                }
                catch (XMLStreamException e) {
                    LOGGER.warn("Could not close XMLEventWriter", (Throwable)e);
                }
                try {
                    if (xmlEventReader != null) {
                        xmlEventReader.close();
                    }
                }
                catch (XMLStreamException e) {
                    LOGGER.warn("Could not close XMLEventReader", (Throwable)e);
                }
            }
        }
        catch (XMLStreamException e) {
            throw new BadRequestException(String.format("Error consuming the operation [%s], the request body is not a valid XML", operation), e);
        }
        return XML_INPUT_FACTORY.createXMLStreamReader(outputByteStream.toInputStream());
    }

    private void writeAttachmentStart(XMLEventWriter xmlEventWriter, String key) throws XMLStreamException {
        xmlEventWriter.add(XML_EVENT_FACTORY.createStartElement("", "", key));
    }

    private void writeAttachmentEnd(XMLEventWriter xmlEventWriter, String key) throws XMLStreamException {
        xmlEventWriter.add(XML_EVENT_FACTORY.createEndElement("", "", key));
    }

    protected abstract void writeAttachmentContent(XMLEventWriter var1, String var2, SoapAttachment var3) throws XMLStreamException;

    private String getAttachmentName(XMLEvent event) {
        String data;
        if (event.isCharacters() && (data = event.asCharacters().getData()).startsWith("cid:")) {
            return data.substring(4);
        }
        return null;
    }
}

