/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.message;

import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.api.message.SoapRequest;

public final class DefaultSoapRequest
implements SoapRequest {
    private final InputStream content;
    private final Map<String, String> soapHeaders;
    private final Map<String, SoapAttachment> attachments;
    private final Map<String, String> transportHeaders;
    private final String contentType;
    private final String operation;
    private final boolean useXMLInitialDeclaration;

    public DefaultSoapRequest(InputStream content, Map<String, String> soapHeaders, Map<String, String> transportHeaders, Map<String, SoapAttachment> attachments, String contentType, String operation, boolean useXMLInitialDeclaration) {
        this.content = content;
        this.soapHeaders = Collections.unmodifiableMap(soapHeaders);
        this.transportHeaders = Collections.unmodifiableMap(transportHeaders);
        this.attachments = Collections.unmodifiableMap(attachments);
        this.contentType = contentType;
        this.operation = operation;
        this.useXMLInitialDeclaration = useXMLInitialDeclaration;
    }

    @Override
    public InputStream getContent() {
        return this.content;
    }

    @Override
    public Map<String, String> getSoapHeaders() {
        return this.soapHeaders;
    }

    @Override
    public Map<String, String> getTransportHeaders() {
        return this.transportHeaders;
    }

    @Override
    public Map<String, SoapAttachment> getAttachments() {
        return this.attachments;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getOperation() {
        return this.operation;
    }

    @Override
    public boolean isUseXMLInitialDeclaration() {
        return this.useXMLInitialDeclaration;
    }
}

