/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.generator;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.mule.soap.api.client.BadRequestException;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.internal.generator.EmptyRequestGenerator;
import org.mule.soap.internal.generator.attachment.AttachmentRequestEnricher;
import org.mule.soap.internal.util.OperationResolver;

public final class SoapRequestGenerator {
    private final EmptyRequestGenerator emptyRequestGenerator;
    private final AttachmentRequestEnricher requestEnricher;

    public SoapRequestGenerator(AttachmentRequestEnricher requestEnricher, OperationResolver port) {
        this.requestEnricher = requestEnricher;
        this.emptyRequestGenerator = new EmptyRequestGenerator(port);
    }

    public XMLStreamReader generate(String operation, InputStream body, String encoding, Map<String, SoapAttachment> attachments) {
        try {
            String requestEncoding = StringUtils.isBlank((CharSequence)encoding) ? StandardCharsets.UTF_8.name() : encoding;
            body = this.checkEmptyStream(body);
            if (body == null) {
                body = new ByteArrayInputStream(this.emptyRequestGenerator.generateRequest(operation).getBytes(requestEncoding));
            }
            return this.requestEnricher.enrichRequest(operation, body, requestEncoding, attachments);
        }
        catch (IOException | XMLStreamException e) {
            throw new BadRequestException("Error generating SOAP request", e);
        }
    }

    private InputStream checkEmptyStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        int b = pushbackInputStream.read();
        if (b == -1) {
            return null;
        }
        pushbackInputStream.unread(b);
        return pushbackInputStream;
    }
}

