/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.api.message;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.internal.message.DefaultSoapRequest;

public class SoapRequestBuilder {
    private InputStream content;
    private ImmutableMap.Builder<String, String> soapHeaders = ImmutableMap.builder();
    private ImmutableMap.Builder<String, String> transportHeaders = ImmutableMap.builder();
    private ImmutableMap.Builder<String, SoapAttachment> attachments = ImmutableMap.builder();
    private String contentType = "application/xml";
    private String operation;
    private boolean useXMLInitialDeclaration;

    SoapRequestBuilder() {
    }

    public SoapRequestBuilder content(InputStream content) {
        this.content = content;
        return this;
    }

    public SoapRequestBuilder content(String content) {
        this.content = new ByteArrayInputStream(content.getBytes());
        return this;
    }

    public SoapRequestBuilder soapHeaders(Map<String, String> soapHeaders) {
        this.soapHeaders.putAll(soapHeaders);
        return this;
    }

    public SoapRequestBuilder transportHeader(String key, String value) {
        this.transportHeaders.put((Object)key, (Object)value);
        return this;
    }

    public SoapRequestBuilder transportHeaders(Map<String, String> headers) {
        this.transportHeaders.putAll(headers);
        return this;
    }

    public SoapRequestBuilder attachment(String name, SoapAttachment attachment) {
        this.attachments.put((Object)name, (Object)attachment);
        return this;
    }

    public SoapRequestBuilder attachments(Map<String, SoapAttachment> attachments) {
        this.attachments.putAll(attachments);
        return this;
    }

    public SoapRequestBuilder contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public SoapRequestBuilder operation(String operation) {
        this.operation = operation;
        return this;
    }

    public SoapRequestBuilder useXMLInitialDeclaration(boolean useXMLInitialDeclaration) {
        this.useXMLInitialDeclaration = useXMLInitialDeclaration;
        return this;
    }

    public DefaultSoapRequest build() {
        Preconditions.checkNotNull((Object)this.operation, (Object)"Missing executing operation");
        return new DefaultSoapRequest(this.content, (Map<String, String>)this.soapHeaders.build(), (Map<String, String>)this.transportHeaders.build(), (Map<String, SoapAttachment>)this.attachments.build(), this.contentType, this.operation, this.useXMLInitialDeclaration);
    }
}

