/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.api;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.mule.soap.api.SoapVersion;
import org.mule.soap.api.SoapWebServiceConfiguration;
import org.mule.soap.api.security.SecurityStrategy;
import org.mule.soap.api.transport.locator.DefaultTransportResourceLocator;
import org.mule.soap.api.transport.locator.TransportResourceLocator;

public class SoapWebServiceConfigurationBuilder {
    private String wsdlLocation;
    private String address;
    private String service;
    private String port;
    private SoapVersion version = SoapVersion.SOAP_11;
    private boolean isMtom;
    private List<SecurityStrategy> securities = new ArrayList<SecurityStrategy>();
    private String encoding;
    private TransportResourceLocator locator = new DefaultTransportResourceLocator();
    private boolean includeRMOperations;

    SoapWebServiceConfigurationBuilder() {
    }

    public SoapWebServiceConfigurationBuilder withWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
        return this;
    }

    public SoapWebServiceConfigurationBuilder withAddress(String address) {
        this.address = address;
        return this;
    }

    public SoapWebServiceConfigurationBuilder withService(String service) {
        this.service = service;
        return this;
    }

    public SoapWebServiceConfigurationBuilder withPort(String port) {
        this.port = port;
        return this;
    }

    public SoapWebServiceConfigurationBuilder withEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public SoapWebServiceConfigurationBuilder withVersion(SoapVersion version) {
        this.version = version;
        return this;
    }

    public SoapWebServiceConfigurationBuilder enableMtom(boolean mtomEnabled) {
        this.isMtom = mtomEnabled;
        return this;
    }

    public SoapWebServiceConfigurationBuilder withSecurity(SecurityStrategy security) {
        this.securities.add(security);
        return this;
    }

    public SoapWebServiceConfigurationBuilder withSecurities(List<SecurityStrategy> security) {
        this.securities.addAll(security);
        return this;
    }

    public SoapWebServiceConfigurationBuilder withResourceLocator(TransportResourceLocator locator) {
        this.locator = locator;
        return this;
    }

    public SoapWebServiceConfigurationBuilder includeRMOperations(boolean includeRMOperations) {
        this.includeRMOperations = includeRMOperations;
        return this;
    }

    public SoapWebServiceConfiguration build() {
        Preconditions.checkNotNull((Object)this.wsdlLocation, (Object)"WSDL location cannot be null");
        Preconditions.checkNotNull((Object)this.service, (Object)"Service cannot be null");
        Preconditions.checkNotNull((Object)this.port, (Object)"Port cannot be null");
        return new SoapWebServiceConfiguration(this.wsdlLocation, this.address, this.service, this.port, this.version, this.isMtom, this.securities, this.locator, this.encoding, this.includeRMOperations);
    }
}

