/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.xml.stax;

import javanet.staxutils.StAXReaderToContentHandler;
import javanet.staxutils.StAXSource;
import javanet.staxutils.helpers.XMLFilterImplEx;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.mule.soap.internal.xml.stax.XMLStreamReaderToContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class StaxSource
extends StAXSource {
    private XMLStreamReader reader;
    protected final StAXReaderToContentHandler handler;
    protected XMLFilterImplEx repeater = new XMLFilterImplEx();
    protected final XMLReader pseudoParser = new PseudoReader();

    public StaxSource(XMLStreamReader reader) {
        super(reader);
        this.reader = reader;
        this.handler = new XMLStreamReaderToContentHandler(reader, this.repeater);
        super.setXMLReader(this.pseudoParser);
        super.setInputSource(new InputSource());
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.reader;
    }

    private final class PseudoReader
    implements XMLReader {
        private EntityResolver entityResolver;
        private DTDHandler dtdHandler;
        private ErrorHandler errorHandler;

        private PseudoReader() {
        }

        @Override
        public boolean getFeature(String name) throws SAXNotRecognizedException {
            if ("http://xml.org/sax/features/namespaces".equals(name)) {
                return true;
            }
            if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
                return StaxSource.this.repeater.getNamespacePrefixes();
            }
            if ("http://xml.org/sax/features/external-general-entities".equals(name)) {
                return true;
            }
            if ("http://xml.org/sax/features/external-parameter-entities".equals(name)) {
                return true;
            }
            throw new SAXNotRecognizedException(name);
        }

        @Override
        public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
            if ("http://xml.org/sax/features/namespaces".equals(name)) {
                if (!value) {
                    throw new SAXNotSupportedException(name);
                }
            } else if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
                StaxSource.this.repeater.setNamespacePrefixes(value);
            } else if (!("http://xml.org/sax/features/external-general-entities".equals(name) || "http://xml.org/sax/features/external-parameter-entities".equals(name) || "http://xml.org/sax/features/validation".equals(name))) {
                throw new SAXNotRecognizedException(name);
            }
        }

        @Override
        public Object getProperty(String name) throws SAXNotRecognizedException {
            if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
                return StaxSource.this.repeater.getLexicalHandler();
            }
            throw new SAXNotRecognizedException(name);
        }

        @Override
        public void setProperty(String name, Object value) throws SAXNotRecognizedException {
            if (!"http://xml.org/sax/properties/lexical-handler".equals(name)) {
                throw new SAXNotRecognizedException(name);
            }
            StaxSource.this.repeater.setLexicalHandler((LexicalHandler)value);
        }

        @Override
        public void setEntityResolver(EntityResolver resolver) {
            this.entityResolver = resolver;
        }

        @Override
        public EntityResolver getEntityResolver() {
            return this.entityResolver;
        }

        @Override
        public void setDTDHandler(DTDHandler handler) {
            this.dtdHandler = handler;
        }

        @Override
        public DTDHandler getDTDHandler() {
            return this.dtdHandler;
        }

        @Override
        public void setContentHandler(ContentHandler handler) {
            StaxSource.this.repeater.setContentHandler(handler);
        }

        @Override
        public ContentHandler getContentHandler() {
            return StaxSource.this.repeater.getContentHandler();
        }

        @Override
        public void setErrorHandler(ErrorHandler handler) {
            this.errorHandler = handler;
        }

        @Override
        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        @Override
        public void parse(InputSource input) throws SAXException {
            this.parse();
        }

        @Override
        public void parse(String systemId) throws SAXException {
            this.parse();
        }

        public void parse() throws SAXException {
            try {
                StaxSource.this.handler.bridge();
            }
            catch (XMLStreamException e) {
                int lineNumber = -1;
                int columnNumber = -1;
                if (e.getLocation() != null) {
                    lineNumber = e.getLocation().getLineNumber();
                    columnNumber = e.getLocation().getColumnNumber();
                }
                SAXParseException se = new SAXParseException(e.getMessage(), null, null, lineNumber, columnNumber, e);
                if (this.errorHandler != null) {
                    this.errorHandler.fatalError(se);
                }
                throw se;
            }
            finally {
                try {
                    StaxSource.this.reader.close();
                }
                catch (XMLStreamException e) {
                    throw new SAXException(e);
                }
            }
        }
    }
}

